pub struct Area{
	pub area_type: String,
	pub value: f64,
}
impl Area{
	/// Creates a new Area instance
	pub fn new() -> Area {
		Area {
			area_type: String::from("Square Centimeters"),
			value: 1.0,
		}
	}
	/// Returns the value of the granted area in square micrometers
	pub fn to_square_micrometers(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else{
			return self.to_square_meters() * 1_000_000_000_000.0
		}
	}
	/// Returns the value of the granted area in square millimeters
	pub fn to_square_millimeters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 1_000_000.0
		}
	}
	/// Returns the value of the granted area in square centimeters
	pub fn to_square_centimeters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 1_000_0.0;
		}
	}
	/// Returns the value of the granted area in square decimeters
	pub fn to_square_decimeters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 100.0;
		}
	}
	/// Returns the value of the granted area in square meters
	pub fn to_square_meters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			if self.area_type == String::from("Square Micrometer"){
				return self.value / 1_000_000_000_000.0;
			}
			else if self.area_type == String::from("Square Millimeters"){
				return self.value / 1_000_000.0;
			}
			else if self.area_type == String::from("Square Centimeters"){
				return self.value * 1_000_0.0;
			}
			else if self.area_type == String::from("Square Decimeters"){
				return self.value * 100.0;
			}
			else if self.area_type == String::from("Square Meters"){
				return self.value;
			}
			else if self.area_type == String::from("Square Decameters"){
				return self.value * 100.0;
			}
			else if self.area_type == String::from("Square Hectometers"){
				return self.value * 1_000_0.0;
			}
			else if self.area_type == String::from("Square Kilometers"){
				return self.value * 1_000_000.0;
			}
			else if self.area_type == String::from("Square Megameters"){
				return self.value * 1_000_000_000_000.0;
			}
			else if self.area_type == String::from("Square Gigameters"){
				return self.value * 1_000_000_000_000_000_000.0;
			}
			else if self.area_type == String::from("Square Terameters"){
				return self.value * 1_000_000_000_000_000_000_000_000.0;
			}
			else if self.area_type == String::from("Square Miles"){
				return self.value * (2.59 * 1_000_000.0);
			}
			else if self.area_type == String::from("Square Yards"){
				return self.value / 1.196;
			}
			else if self.area_type == String::from("Square Feet"){
				return self.value / 10.764;
			}
			else if self.area_type == String::from("Square Inches"){
				return self.value / 1550.0;
			}
			else{
				println!("Invalid area type");
				return self.value;
			}
		}
	}
	/// Returns the value of the area granted in square decameters
	pub fn to_square_decameters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 100.0;
		}
	}
	/// Returns the value of the granted area in square hectometers
	pub fn to_square_hectometers(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 1_000_0.0;
		}
	}
	/// Returns the value of the granted area in square kilometers
	pub fn to_square_kilometers(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 1_000_000.0;
		}
	}
	/// Returns the value of the granted area in square megameters
	pub fn to_square_megameters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 1_000_000_00.0;
		}
	}
	/// Returns the value of the granted area in square gigameters
	pub fn to_square_gigameters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 1_000_000_000_0.0;
		}
	}
	/// Returns the value of the granted area in square terameters
	pub fn to_square_terameters(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / 1_000_000_000_000.0;
		}
	}
	/// Returns the value of the granted area in square miles
	pub fn to_square_miles(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() / (2.59 * 1_000_000.00);
		}
	}
	/// Returns the value of the granted area in square yards
	pub fn to_square_yards(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 1.196;
		}
	}
	/// Returns the value of the granted area in square feet
	pub fn to_square_feet(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 10.764;
		}
	}
	/// Returns the value of the granted area in square inches
	pub fn to_square_inches(&self) -> f64 {
		if self.value > 1_000_000_000_000_000f64{
			return self.value;
		}
		else {
			return self.to_square_meters() * 1550.0;
		}
	}
}