//! Module that provides functions for temperature conversion.
//! [Simple Example]:
//! ```
//! use general_tools::conversions::temperature_conversions::Temperature;
//! 
//! fn main() {
//! 	let temperature: Temperature{
//! 		temperature_type: String::from("Celsius"), value: 10.55
//! 	};
//! 
//! 	// or:
//! 	/*
//! 		let mut temperature = Temperature::new();
//! 
//! 		temperature.temperature_type = String::from("Celsius");
//! 		temperature.value = 10.55;
//! 	*/
//! 	println!("{} °C to Fahrenheit: {} °F", temperature.value, temperature.to_fahrenheit()));
//! }
//! ```
//! 
//! Output: 
//! 
//! ```
//! 10.55 °C to Fahrenheit: 50.99 °F
//! ```
pub struct Temperature {
	pub temperature_type: String,
	pub value: f64,
}

impl Temperature {
	/// Creates a new Temperature instance
	pub fn new() -> Temperature{
		Temperature{
			temperature_type: String::from("Celsius"),
			value: 0.0,
		}
	}
	/// Converts the granted temperature to Celsius
	pub fn to_celsius(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return self.value;
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return (self.value - 32.0) / 1.8
		} 
		else if self.temperature_type == String::from("Kelvin") {
			return self.value - 273.15;
		}
		else if self.temperature_type == String::from("Rankine") {
			return self.value / 1.8 - 273.15;
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value * (100.0 / 33.0);
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value * 1.25;
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
	/// Converts the granted temperature to Fahrenheit
	pub fn to_fahrenheit(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return self.value * 1.8 + 32.0;
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return self.value;
		} 
		else if self.temperature_type == String::from("Kelvin") {
			return self.value * 1.8 - 459.889;
		}
		else if self.temperature_type == String::from("Rankine") {
			return self.value - 459.67;
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value * 5.45454545455 + 32f64;
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value * 2.25 + 32f64;
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
	/// Converts the granted temperature to Kelvin
	pub fn to_kelvin(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return self.value + 273.15;
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return (self.value + 459.67) / 1.8;
		} 
		else if self.temperature_type == String::from("Kelvin") {
			return self.value
		}
		else if self.temperature_type == String::from("Rankine") {
			return self.value / 1.8;
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value * (100. / 33.0) + 273.15;
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value * 1.25 + 273.15;
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
	/// Converts the granted temperature to Rankine
	pub fn to_rankine(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return (self.value + 273.15) * 1.8;
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return self.value + 459.67;
		} 
		else if self.temperature_type == String::from("Kelvin") {
			return self.value * 1.8;
		}
		else if self.temperature_type == String::from("Rankine") {
			return self.value;
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value * (60.0/11.0) + 491.67;
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value * 2.25 + 491.67;
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
	/// Converts the granted temperature to Newton
	pub fn to_newton(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return self.value * (33.0 / 100.0);
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return (self.value - 32.0) * (11.0 / 60.0);
		} 
		else if self.temperature_type == String::from("Kelvin") {
			return (self.value - 273.15) * (33.0 / 100.0);
		}
		else if self.temperature_type == String::from("Rankine") {
			return (self.value - 491.67) * (11.0 / 60.0);
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value;
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value * (33.0 / 80.0);
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
	/// Converts the granted temperature to Réaumur
	pub fn to_reaumur(&self) -> f64 {
		if self.temperature_type == String::from("Celsius") {
			return self.value * 0.8;
		}
		else if self.temperature_type == String::from("Fahrenheit") {
			return (self.value - 32.0) / 2.25;
		}
		else if self.temperature_type == String::from("Kelvin") {
			return (self.value - 273.15) * 0.8;
		}
		else if self.temperature_type == String::from("Rankine") {
			return (self.value - 491.67) / 2.25;
		}
		else if self.temperature_type == String::from("Newton") {
			return self.value * (33.0 / 80.0);
		}
		else if self.temperature_type == String::from("Réaumur") {
			return self.value;
		}
		else {
			println!("Unsupported temperature type");
			return 0.0;
		}
	}
}