// Tipo Especial

pub struct Temperature {
	temperature_type: String,
	value: f64,
}

pub fn to_fahrenheit(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return temperature.value;
	} 
	else if temperature.temperature_type == String::from("Celsius") {
		return temperature.value * 1.8 + 32.0;
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return temperature.value * 1.8 - 459.889;
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return temperature.value - 459.67;
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value * 5.45454545455 + 32f64;
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value * 2.25 + 32f64;
	}
	else {
		panic!("Unsupported temperature type");
	}
}

pub fn to_celsius(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return (temperature.value - 32.0) / 1.8
	} 
	else if temperature.temperature_type == String::from("Celsius") {
		return temperature.value;
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return temperature.value - 273.15;
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return temperature.value / 1.8 - 273.15;
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value * (100.0 / 33.0);
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value * 1.25;
	}
	else {
		panic!("Unsupported temperature type");
	}
}

pub fn to_kelvin(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return (temperature.value + 459.67) / 1.8;
	} 
	else if temperature.temperature_type == String::from("Celsius") {
		return temperature.value + 273.15;
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return temperature.value
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return temperature.value / 1.8;
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value * (100. / 33.0) + 273.15;
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value * 1.25 + 273.15;
	}
	else {
		panic!("Unsupported temperature type");
	}
}

pub fn to_rankine(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return temperature.value + 459.67;
	} 
	else if temperature.temperature_type == String::from("Celsius") {
		return (temperature.value + 273.15) * 1.8;
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return temperature.value * 1.8;
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return temperature.value;
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value * (60.0/11.0) + 491.67;
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value * 2.25 + 491.67;
	}
	else {
		panic!("Unsupported temperature type");
	}
}

pub fn to_newton(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return (temperature.value - 32.0) * (60.0 / 11.0);
	} 
	else if temperature.temperature_type == String::from("Celsius") {
		return temperature.value * (100.0 / 33.0);
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return (temperature.value - 273.15) * (100.0 / 33.0);
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return (temperature.value - 491.67) * (60.0 / 11.0);
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value;
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value * (33.0 / 80.0);
	}
	else {
		panic!("Unsupported temperature type");
	}
}

pub fn to_reaumur(temperature: Temperature) -> f64 {
	if temperature.temperature_type == String::from("Fahrenheit") {
		return (temperature.value - 32.0) / 2.25;
	}
	else if temperature.temperature_type == String::from("Celsius") {
		return temperature.value * 0.8;
	}
	else if temperature.temperature_type == String::from("Kelvin") {
		return (temperature.value - 273.15) * 0.8;
	}
	else if temperature.temperature_type == String::from("Rankine") {
		return (temperature.value - 491.67) / 2.25;
	}
	else if temperature.temperature_type == String::from("Newton") {
		return temperature.value * (33.0 / 80.0);
	}
	else if temperature.temperature_type == String::from("Réaumur") {
		return temperature.value;
	}
	else {
		panic!("Unsupported temperature type");
	}
}