use super::*;
use core::ops::{Deref, DerefMut};

#[derive(Clone, Copy)]
pub struct ByteSlice<'a>(&'a [u8]);

impl<'a> ByteSlice<'a> {
    #[inline]
    pub const fn new(slice: &'a [u8]) -> Self {
        ByteSlice(slice)
    }
}

impl<'a> Deref for ByteSlice<'a> {
    type Target = [u8];
    #[inline]
    fn deref(&self) -> &Self::Target {
        self.0
    }
}

impl_byteorder!(ByteSlice<'a> no_write);

////////////////////////////////////////////////////////////////////////////////////

pub struct ByteMutSlice<'a>(&'a mut [u8]);

impl<'a> ByteMutSlice<'a> {
    #[inline]
    pub fn new(slice: &'a mut [u8]) -> Self {
        ByteMutSlice(slice)
    }
}

impl<'a> Deref for ByteMutSlice<'a> {
    type Target = [u8];
    #[inline]
    fn deref(&self) -> &Self::Target {
        self.0
    }
}

impl<'a> DerefMut for ByteMutSlice<'a> {
    #[inline]
    fn deref_mut(&mut self) -> &mut Self::Target {
        self.0
    }
}

impl_byteorder!(ByteMutSlice<'a>);
