extern crate gempress;

use gempress::gemini;
use gempress::Gempress;
use std::path::PathBuf;

fn index_handler(req: Box<gemini::Request>, mut res: Box<gemini::Response>) {
    res.send("Hello from index route!".as_bytes());
}

fn main() {
    // Run make_cert.sh to generate a certificate
    let config = gempress::Config::from_identity(PathBuf::from("identity.pfx"), "password".into());

    let mut app = Gempress::new(config);

    app.on("/", &index_handler);

    app.listen(1965, || {
        println!("Listening on port 1965");
    })
    .unwrap();
}
