# Gempress

An Express.js inspired server framework for the [Gemini
protocol](https://gemini.circumlunar.space/).

The goal of Gempress is to provide a minimal yet powerful API to build dynamic
gemini applications.

## A simple server

Setting up a Gempress server with a single route looks like this:

```rs
fn index_handler(req: Box<gemini::Request>, mut res: Box<gemini::Response>) {
    res.send("Hello from index route!".as_bytes());
}

fn main() {
    let config = gempress::Config::from_identity(PathBuf::from("identity.pfx"), "password".into());
    let mut app = Gempress::new(config);

    app.on("/", &index_handler);

    app.listen(1965, || {
        println!("Listening on port 1965");
    })
    .unwrap();
}
```

See the [examples](./examples) directory for more elaborate examples.

## Generating a self-signed certificate

To use a Gempress server, you will need a TLS certificate bundled in an
identity. To generate a certificate, simply execute the following snippet.
Substitute the `localhost` with your own hostname to generate a certificate
exposed to the public.

```sh
openssl req -x509 -newkey rsa:4096 -keyout key.pem -out cert.pem -days 365 -nodes -subj '/CN=localhost'
openssl pkcs12 -export -out identity.pfx -inkey key.pem -in cert.pem

# Cleanup old files
rm key.pem cert.pem
```
