// This file defines several constants with integration points data.
//
// Each integration point (IP) is defined by 3 reference
// coordinates (r, s, t) and the weight (w).
//
// The 1D and 2D geometries have s and/or t equal to zero as appropriate.
//
// The data structure is a 2D array such that [[f64; 4]; NIP]
// where NIP is the number of integration points in a particular set.
// "4" corresponds to (r, s, t) and the weight (w).

// -----------------------------------------------------------------------
// -- LIN ----------------------------------------------------------------
// -----------------------------------------------------------------------

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_LIN_LEGENDRE_1: [[f64; 4]; 1] = [
    [0.0, 0.0, 0.0, 2.0]
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_LIN_LEGENDRE_2: [[f64; 4]; 2] = [
    [-0.5773502691896257, 0.0, 0.0, 1.0],
    [ 0.5773502691896257, 0.0, 0.0, 1.0],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_LIN_LEGENDRE_3: [[f64; 4]; 3] = [
    [-0.7745966692414834, 0.0, 0.0, 0.5555555555555556],
    [ 0.0000000000000000, 0.0, 0.0, 0.8888888888888888],
    [ 0.7745966692414834, 0.0, 0.0, 0.5555555555555556],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_LIN_LEGENDRE_4: [[f64; 4]; 4] = [
    [-0.8611363115940526, 0.0, 0.0, 0.3478548451374538],
    [-0.3399810435848562, 0.0, 0.0, 0.6521451548625462],
    [ 0.3399810435848562, 0.0, 0.0, 0.6521451548625462],
    [ 0.8611363115940526, 0.0, 0.0, 0.3478548451374538],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_LIN_LEGENDRE_5: [[f64; 4]; 5] = [
    [-0.9061798459386640, 0.0, 0.0, 0.2369268850561891],
    [-0.5384693101056831, 0.0, 0.0, 0.4786286704993665],
    [ 0.0000000000000000, 0.0, 0.0, 0.5688888888888889],
    [ 0.5384693101056831, 0.0, 0.0, 0.4786286704993665],
    [ 0.9061798459386640, 0.0, 0.0, 0.2369268850561891],
];

// -----------------------------------------------------------------------
// -- TRI ----------------------------------------------------------------
// -----------------------------------------------------------------------

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TRI_INTERNAL_1: [[f64; 4]; 1] = [
    [1.0 / 3.0, 1.0 / 3.0, 0.0, 1.0 / 2.0],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TRI_INTERNAL_3: [[f64; 4]; 3] = [
    [1.0 / 6.0, 1.0 / 6.0, 0.0, 1.0 / 6.0],
    [2.0 / 3.0, 1.0 / 6.0, 0.0, 1.0 / 6.0],
    [1.0 / 6.0, 2.0 / 3.0, 0.0, 1.0 / 6.0],
];

/// Edge integration points and weights
#[rustfmt::skip]
pub const IP_TRI_EDGE_3: [[f64; 4]; 3] = [
    [0.5, 0.5, 0.0, 1.0 / 6.0],
    [0.0, 0.5, 0.0, 1.0 / 6.0],
    [0.5, 0.0, 0.0, 1.0 / 6.0],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TRI_INTERNAL_4: [[f64; 4]; 4] = [
    [1.0 / 3.0, 1.0 / 3.0, 0.0, -27.0 / 96.0],
    [1.0 / 5.0, 1.0 / 5.0, 0.0,  25.0 / 96.0],
    [3.0 / 5.0, 1.0 / 5.0, 0.0,  25.0 / 96.0],
    [1.0 / 5.0, 3.0 / 5.0, 0.0,  25.0 / 96.0],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TRI_INTERNAL_12: [[f64; 4]; 12] = [
    [0.873821971016996, 0.063089014491502, 0.0, 0.0254224531851035],
    [0.063089014491502, 0.873821971016996, 0.0, 0.0254224531851035],
    [0.063089014491502, 0.063089014491502, 0.0, 0.0254224531851035],
    [0.501426509658179, 0.249286745170910, 0.0, 0.0583931378631895],
    [0.249286745170910, 0.501426509658179, 0.0, 0.0583931378631895],
    [0.249286745170910, 0.249286745170910, 0.0, 0.0583931378631895],
    [0.053145049844817, 0.310352451033784, 0.0, 0.041425537809187 ],
    [0.310352451033784, 0.053145049844817, 0.0, 0.041425537809187 ],
    [0.053145049844817, 0.636502499121398, 0.0, 0.041425537809187 ],
    [0.310352451033784, 0.636502499121398, 0.0, 0.041425537809187 ],
    [0.636502499121398, 0.053145049844817, 0.0, 0.041425537809187 ],
    [0.636502499121398, 0.310352451033784, 0.0, 0.041425537809187 ],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TRI_INTERNAL_16: [[f64; 4]; 16] = [
    [3.33333333333333e-01, 3.33333333333333e-01, 0.0, 7.21578038388935e-02],
    [8.14148234145540e-02, 4.59292588292723e-01, 0.0, 4.75458171336425e-02],
    [4.59292588292723e-01, 8.14148234145540e-02, 0.0, 4.75458171336425e-02],
    [4.59292588292723e-01, 4.59292588292723e-01, 0.0, 4.75458171336425e-02],
    [6.58861384496480e-01, 1.70569307751760e-01, 0.0, 5.16086852673590e-02],
    [1.70569307751760e-01, 6.58861384496480e-01, 0.0, 5.16086852673590e-02],
    [1.70569307751760e-01, 1.70569307751760e-01, 0.0, 5.16086852673590e-02],
    [8.98905543365938e-01, 5.05472283170310e-02, 0.0, 1.62292488115990e-02],
    [5.05472283170310e-02, 8.98905543365938e-01, 0.0, 1.62292488115990e-02],
    [5.05472283170310e-02, 5.05472283170310e-02, 0.0, 1.62292488115990e-02],
    [8.39477740995800e-03, 2.63112829634638e-01, 0.0, 1.36151570872175e-02],
    [7.28492392955404e-01, 8.39477740995800e-03, 0.0, 1.36151570872175e-02],
    [2.63112829634638e-01, 7.28492392955404e-01, 0.0, 1.36151570872175e-02],
    [8.39477740995800e-03, 7.28492392955404e-01, 0.0, 1.36151570872175e-02],
    [7.28492392955404e-01, 2.63112829634638e-01, 0.0, 1.36151570872175e-02],
    [2.63112829634638e-01, 8.39477740995800e-03, 0.0, 1.36151570872175e-02],
];

// -----------------------------------------------------------------------
// -- QUA ----------------------------------------------------------------
// -----------------------------------------------------------------------

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_QUA_LEGENDRE_1: [[f64; 4]; 1] = [
    [0.0, 0.0, 0.0, 4.0],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_QUA_LEGENDRE_4: [[f64; 4]; 4] = [
    [-0.5773502691896257, -0.5773502691896257, 0.0, 1.0],
    [ 0.5773502691896257, -0.5773502691896257, 0.0, 1.0],
    [-0.5773502691896257,  0.5773502691896257, 0.0, 1.0],
    [ 0.5773502691896257,  0.5773502691896257, 0.0, 1.0],
];

/// Wilson's integration points and weights. "Corner" version
#[rustfmt::skip]
pub const IP_QUA_WILSON_CORNER_5: [[f64; 4]; 5] = [
    [-1.0, -1.0, 0.0, 0.3333333333333333],
    [ 1.0, -1.0, 0.0, 0.3333333333333333],
    [ 0.0,  0.0, 0.0, 2.6666666666666665],
    [-1.0,  1.0, 0.0, 0.3333333333333333],
    [ 1.0,  1.0, 0.0, 0.3333333333333333],
];

/// Wilson's integration points and weights. "Stable" version version with w0=0.004 and wa=0.999 to mimic 4-point rule
#[rustfmt::skip]
pub const IP_QUA_WILSON_STABLE_5: [[f64; 4]; 5] = [
    [-0.5776391000000000, -0.5776391000000000, 0.0, 0.999],
    [ 0.5776391000000000, -0.5776391000000000, 0.0, 0.999],
    [ 0.0000000000000000,  0.0000000000000000, 0.0, 0.004],
    [-0.5776391000000000,  0.5776391000000000, 0.0, 0.999],
    [ 0.5776391000000000,  0.5776391000000000, 0.0, 0.999],
];

/// Wilson's integration points and weights.
#[rustfmt::skip]
pub const IP_QUA_WILSON_8: [[f64; 4]; 8] = [
    [-0.8819171036881969, -0.8819171036881969, 0.0, 0.1836734693877551],
    [ 0.0000000000000000, -0.6831300510639732, 0.0, 0.8163265306122449],
    [ 0.8819171036881969, -0.8819171036881969, 0.0, 0.1836734693877551],
    [-0.6831300510639732,  0.0000000000000000, 0.0, 0.8163265306122449],
    [ 0.6831300510639732,  0.0000000000000000, 0.0, 0.8163265306122449],
    [-0.8819171036881969,  0.8819171036881969, 0.0, 0.1836734693877551],
    [ 0.0000000000000000,  0.6831300510639732, 0.0, 0.8163265306122449],
    [ 0.8819171036881969,  0.8819171036881969, 0.0, 0.1836734693877551],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_QUA_LEGENDRE_9: [[f64; 4]; 9] = [
    [-0.7745966692414834, -0.7745966692414834, 0.0, 25.0 / 81.0],
    [ 0.0000000000000000, -0.7745966692414834, 0.0, 40.0 / 81.0],
    [ 0.7745966692414834, -0.7745966692414834, 0.0, 25.0 / 81.0],
    [-0.7745966692414834,  0.0000000000000000, 0.0, 40.0 / 81.0],
    [ 0.0000000000000000,  0.0000000000000000, 0.0, 64.0 / 81.0],
    [ 0.7745966692414834,  0.0000000000000000, 0.0, 40.0 / 81.0],
    [-0.7745966692414834,  0.7745966692414834, 0.0, 25.0 / 81.0],
    [ 0.0000000000000000,  0.7745966692414834, 0.0, 40.0 / 81.0],
    [ 0.7745966692414834,  0.7745966692414834, 0.0, 25.0 / 81.0],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_QUA_LEGENDRE_16: [[f64; 4]; 16] = [
    [-0.8611363115940526, -0.8611363115940526, 0.0, 0.1210029932856019],
    [-0.3399810435848563, -0.8611363115940526, 0.0, 0.2268518518518519],
    [ 0.3399810435848563, -0.8611363115940526, 0.0, 0.2268518518518519],
    [ 0.8611363115940526, -0.8611363115940526, 0.0, 0.1210029932856019],
    [-0.8611363115940526, -0.3399810435848563, 0.0, 0.2268518518518519],
    [-0.3399810435848563, -0.3399810435848563, 0.0, 0.4252933030106947],
    [ 0.3399810435848563, -0.3399810435848563, 0.0, 0.4252933030106947],
    [ 0.8611363115940526, -0.3399810435848563, 0.0, 0.2268518518518519],
    [-0.8611363115940526,  0.3399810435848563, 0.0, 0.2268518518518519],
    [-0.3399810435848563,  0.3399810435848563, 0.0, 0.4252933030106947],
    [ 0.3399810435848563,  0.3399810435848563, 0.0, 0.4252933030106947],
    [ 0.8611363115940526,  0.3399810435848563, 0.0, 0.2268518518518519],
    [-0.8611363115940526,  0.8611363115940526, 0.0, 0.1210029932856019],
    [-0.3399810435848563,  0.8611363115940526, 0.0, 0.2268518518518519],
    [ 0.3399810435848563,  0.8611363115940526, 0.0, 0.2268518518518519],
    [ 0.8611363115940526,  0.8611363115940526, 0.0, 0.1210029932856019],
];

// -----------------------------------------------------------------------
// -- TET ----------------------------------------------------------------
// -----------------------------------------------------------------------

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TET_INTERNAL_1: [[f64; 4]; 1] = [
    [1.0 / 4.0, 1.0 / 4.0, 1.0 / 4.0, 1.0 / 6.0],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TET_INTERNAL_4: [[f64; 4]; 4] = [
    [0.5854101966249684, 0.1381966011250105, 0.1381966011250105, 0.041666666666666],
    [0.1381966011250105, 0.5854101966249684, 0.1381966011250105, 0.041666666666666],
    [0.1381966011250105, 0.1381966011250105, 0.5854101966249684, 0.041666666666666],
    [0.1381966011250105, 0.1381966011250105, 0.1381966011250105, 0.041666666666666],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TET_INTERNAL_5: [[f64; 4]; 5] = [
    [1.0 / 4.0, 1.0 / 4.0, 1.0 / 4.0, -2.0 / 15.0],
    [1.0 / 6.0, 1.0 / 6.0, 1.0 / 6.0,  3.0 / 40.0],
    [1.0 / 6.0, 1.0 / 6.0, 1.0 / 2.0,  3.0 / 40.0],
    [1.0 / 6.0, 1.0 / 2.0, 1.0 / 6.0,  3.0 / 40.0],
    [1.0 / 2.0, 1.0 / 6.0, 1.0 / 6.0,  3.0 / 40.0],
];

/// Internal integration points and weights
#[rustfmt::skip]
pub const IP_TET_INTERNAL_6: [[f64; 4]; 6] = [
    [ 1.0,  0.0,  0.0, 4.0 / 3.0],
    [-1.0,  0.0,  0.0, 4.0 / 3.0],
    [ 0.0,  1.0,  0.0, 4.0 / 3.0],
    [ 0.0, -1.0,  0.0, 4.0 / 3.0],
    [ 0.0,  0.0,  1.0, 4.0 / 3.0],
    [ 0.0,  0.0, -1.0, 4.0 / 3.0],
];

// -----------------------------------------------------------------------
// -- HEX ----------------------------------------------------------------
// -----------------------------------------------------------------------

/// Iron's integration points and weights
#[rustfmt::skip]
pub const IP_HEX_IRONS_6: [[f64; 4]; 6] = [
    [-1.0,  0.0,  0.0, 4.0 / 3.0],
    [ 1.0,  0.0,  0.0, 4.0 / 3.0],
    [ 0.0, -1.0,  0.0, 4.0 / 3.0],
    [ 0.0,  1.0,  0.0, 4.0 / 3.0],
    [ 0.0,  0.0, -1.0, 4.0 / 3.0],
    [ 0.0,  0.0,  1.0, 4.0 / 3.0],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_HEX_LEGENDRE_8: [[f64; 4]; 8] = [
    [-0.5773502691896257, -0.5773502691896257, -0.5773502691896257, 1.0],
    [ 0.5773502691896257, -0.5773502691896257, -0.5773502691896257, 1.0],
    [-0.5773502691896257,  0.5773502691896257, -0.5773502691896257, 1.0],
    [ 0.5773502691896257,  0.5773502691896257, -0.5773502691896257, 1.0],
    [-0.5773502691896257, -0.5773502691896257,  0.5773502691896257, 1.0],
    [ 0.5773502691896257, -0.5773502691896257,  0.5773502691896257, 1.0],
    [-0.5773502691896257,  0.5773502691896257,  0.5773502691896257, 1.0],
    [ 0.5773502691896257,  0.5773502691896257,  0.5773502691896257, 1.0],
];

/// Wilson's integration points and weights. "Corner" version
#[rustfmt::skip]
pub const IP_HEX_WILSON_CORNER_9: [[f64; 4]; 9] = [
    [-1.0, -1.0, -1.0,  0.3333333333333333],
    [ 1.0, -1.0, -1.0,  0.3333333333333333],
    [-1.0,  1.0, -1.0,  0.3333333333333333],
    [ 1.0,  1.0, -1.0,  0.3333333333333333],
    [ 0.0,  0.0,  0.0,  5.3333333333333330],
    [-1.0, -1.0,  1.0,  0.3333333333333333],
    [ 1.0, -1.0,  1.0,  0.3333333333333333],
    [-1.0,  1.0,  1.0,  0.3333333333333333],
    [ 1.0,  1.0,  1.0,  0.3333333333333333],
];

/// Wilson's integration points and weights. "Stable" version
#[rustfmt::skip]
pub const IP_HEX_WILSON_STABLE_9: [[f64; 4]; 9] = [
    [-0.5776391, -0.5776391, -0.5776391000000000,  0.999],
    [ 0.5776391, -0.5776391, -0.5776391000000000,  0.999],
    [-0.5776391,  0.5776391, -0.5776391000000000,  0.999],
    [ 0.5776391,  0.5776391, -0.5776391000000000,  0.999],
    [ 0.0000000,  0.0000000,  0.0000000000000000,  0.008],
    [-0.5776391, -0.5776391,  0.5776391000000000,  0.999],
    [ 0.5776391, -0.5776391,  0.5776391000000000,  0.999],
    [-0.5776391,  0.5776391,  0.5776391000000000,  0.999],
    [ 0.5776391,  0.5776391,  0.5776391000000000,  0.999],
];

/// Iron's integration points and weights
#[rustfmt::skip]
pub const IP_HEX_IRONS_14: [[f64; 4]; 14] = [
    [ 0.7958224257542215,  0.0000000000000000,  0.0000000000000000,  0.8864265927977839],
    [-0.7958224257542215,  0.0000000000000000,  0.0000000000000000,  0.8864265927977839],
    [ 0.0000000000000000,  0.7958224257542215,  0.0000000000000000,  0.8864265927977839],
    [ 0.0000000000000000, -0.7958224257542215,  0.0000000000000000,  0.8864265927977839],
    [ 0.0000000000000000,  0.0000000000000000,  0.7958224257542215,  0.8864265927977839],
    [ 0.0000000000000000,  0.0000000000000000, -0.7958224257542215,  0.8864265927977839],
    [ 0.7587869106393281,  0.7587869106393281,  0.7587869106393281,  0.3351800554016621],
    [-0.7587869106393281,  0.7587869106393281,  0.7587869106393281,  0.3351800554016621],
    [ 0.7587869106393281, -0.7587869106393281,  0.7587869106393281,  0.3351800554016621],
    [-0.7587869106393281, -0.7587869106393281,  0.7587869106393281,  0.3351800554016621],
    [ 0.7587869106393281,  0.7587869106393281, -0.7587869106393281,  0.3351800554016621],
    [-0.7587869106393281,  0.7587869106393281, -0.7587869106393281,  0.3351800554016621],
    [ 0.7587869106393281, -0.7587869106393281, -0.7587869106393281,  0.3351800554016621],
    [-0.7587869106393281, -0.7587869106393281, -0.7587869106393281,  0.3351800554016621],
];

/// Conventional Legendre integration points and weights
#[rustfmt::skip]
pub const IP_HEX_LEGENDRE_27: [[f64; 4]; 27] = [
    [-0.774596669241483, -0.774596669241483, -0.774596669241483, 0.171467764060357],
    [ 0.000000000000000, -0.774596669241483, -0.774596669241483, 0.274348422496571],
    [ 0.774596669241483, -0.774596669241483, -0.774596669241483, 0.171467764060357],
    [-0.774596669241483,  0.000000000000000, -0.774596669241483, 0.274348422496571],
    [ 0.000000000000000,  0.000000000000000, -0.774596669241483, 0.438957475994513],
    [ 0.774596669241483,  0.000000000000000, -0.774596669241483, 0.274348422496571],
    [-0.774596669241483,  0.774596669241483, -0.774596669241483, 0.171467764060357],
    [ 0.000000000000000,  0.774596669241483, -0.774596669241483, 0.274348422496571],
    [ 0.774596669241483,  0.774596669241483, -0.774596669241483, 0.171467764060357],
    [-0.774596669241483, -0.774596669241483,  0.000000000000000, 0.274348422496571],
    [ 0.000000000000000, -0.774596669241483,  0.000000000000000, 0.438957475994513],
    [ 0.774596669241483, -0.774596669241483,  0.000000000000000, 0.274348422496571],
    [-0.774596669241483,  0.000000000000000,  0.000000000000000, 0.438957475994513],
    [ 0.000000000000000,  0.000000000000000,  0.000000000000000, 0.702331961591221],
    [ 0.774596669241483,  0.000000000000000,  0.000000000000000, 0.438957475994513],
    [-0.774596669241483,  0.774596669241483,  0.000000000000000, 0.274348422496571],
    [ 0.000000000000000,  0.774596669241483,  0.000000000000000, 0.438957475994513],
    [ 0.774596669241483,  0.774596669241483,  0.000000000000000, 0.274348422496571],
    [-0.774596669241483, -0.774596669241483,  0.774596669241483, 0.171467764060357],
    [ 0.000000000000000, -0.774596669241483,  0.774596669241483, 0.274348422496571],
    [ 0.774596669241483, -0.774596669241483,  0.774596669241483, 0.171467764060357],
    [-0.774596669241483,  0.000000000000000,  0.774596669241483, 0.274348422496571],
    [ 0.000000000000000,  0.000000000000000,  0.774596669241483, 0.438957475994513],
    [ 0.774596669241483,  0.000000000000000,  0.774596669241483, 0.274348422496571],
    [-0.774596669241483,  0.774596669241483,  0.774596669241483, 0.171467764060357],
    [ 0.000000000000000,  0.774596669241483,  0.774596669241483, 0.274348422496571],
    [ 0.774596669241483,  0.774596669241483,  0.774596669241483, 0.171467764060357],
];
