use gemachain_sdk::{
    hash::Hash,
    instruction::CompiledInstruction,
    signature::{Keypair, Signer},
    stake,
    system_instruction::SystemInstruction,
    system_program, system_transaction,
    transaction::Transaction,
};

pub fn test_tx() -> Transaction {
    let keypair1 = Keypair::new();
    let pubkey1 = keypair1.pubkey();
    let zero = Hash::default();
    system_transaction::transfer(&keypair1, &pubkey1, 42, zero)
}

pub fn test_multisig_tx() -> Transaction {
    let keypair0 = Keypair::new();
    let keypair1 = Keypair::new();
    let keypairs = vec![&keypair0, &keypair1];
    let carats = 5;
    let blockhash = Hash::default();

    let transfer_instruction = SystemInstruction::Transfer { carats };

    let program_ids = vec![system_program::id(), stake::program::id()];

    let instructions = vec![CompiledInstruction::new(
        0,
        &transfer_instruction,
        vec![0, 1],
    )];

    Transaction::new_with_compiled_instructions(
        &keypairs,
        &[],
        blockhash,
        program_ids,
        instructions,
    )
}
