use gelbooru_api::*;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let auth_qs = std::env::var("GELBOORU")?;
    let auth = AuthDetails::from_query_string(&auth_qs)?;
    let client = Client::with_auth(auth);

    let tags = tags()
        .limit(10000)
        .send(&client)
        .await?;

    for tag in tags {
        println!("Real tag: {}", &tag.r#type);
        println!("Est  tag: {:?}", tag.tag_type());
    }

    /*
    for post in posts {
        println!(
            "\t\"{title}\" by {owner} at {created_at}",
            title = post.title(),
            owner = post.owner(),
            created_at = post.created_at(),
        );
    }
    */

    Ok(())
}
