use gelbooru_api::*;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let auth_qs = std::env::var("GELBOORU")?;
    let auth = AuthDetails::from_query_string(&auth_qs)?;
    let client = Client::with_auth(auth);

    let tags = tags().limit(5).after_id(69420)
        .ascending(false)
        .order_by(Ordering::Date)
        .send(&client).await?;

    for tag in tags {
        dbg!(tag);
    }

    /*
    for post in posts {
        println!(
            "\t\"{title}\" by {owner} at {created_at}",
            title = post.title(),
            owner = post.owner(),
            created_at = post.created_at(),
        );
    }
    */

    Ok(())
}
