use gelbooru_api::*;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let auth_qs = std::env::var("GELBOORU")?;
    let auth = AuthDetails::from_query_string(&auth_qs)?;
    let client = Client::with_auth(auth);

    let req = posts()
        .limit(5)
        .rating(Rating::Safe)
        .tags(&["hatsune_miku", "solo"])
        .tags_raw("aqua_hair");

    let posts = req.send(&client).await?;

    for post in posts {
        println!(
            "Post {id} created at {created_at} by {owner} [{image_url}]",
            id = post.id(),
            created_at = post.created_at(),
            owner = post.owner(),
            image_url = post.image_url(),
        );
    }

    /*
    for post in posts {
        println!(
            "\t\"{title}\" by {owner} at {created_at}",
            title = post.title(),
            owner = post.owner(),
            created_at = post.created_at(),
        );
    }
    */

    Ok(())
}
