use gecko::contract;
mod generic;

const ID: &str = "ethereum";
const CONTRACT_ADDRESS: &str = "0x0D8775F648430679A709E98d2b0Cb6250d2887EF";
static VS_CURRENCY: &str = "usd";

#[tokio::test]
async fn test_info() {
    let resource = contract::Info::required(ID.to_string(), CONTRACT_ADDRESS.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_market_chart() {
    let resource = contract::MarketChart::required(
        ID.to_string(),
        CONTRACT_ADDRESS.to_string(),
        VS_CURRENCY.to_string(),
        "14".to_string(),
    );
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_market_chart_range() {
    let from: i64 = 1609480800;
    let to: i64 = 1622523600;
    let resource = contract::MarketChartRange::required(
        ID.to_string(),
        CONTRACT_ADDRESS.to_string(),
        VS_CURRENCY.to_string(),
        from,
        to,
    );
    generic::test_get(&resource).await;
}
