//! # `/companies`
//!
//! - [/companies/public_treasur/{coin_id}](Companies)
use crate::Route;

pub struct Companies {
    endpoint: String,
    pub coin_id: String,
}

impl Companies {
    pub fn required(coin_id: String) -> Companies {
        Companies {
            coin_id,
            ..Default::default()
        }
    }
}

impl Default for Companies {
    fn default() -> Companies {
        Companies {
            endpoint: String::from("/companies/public_treasury/COIN_ID"),
            coin_id: String::from(""),
        }
    }
}

impl Route for Companies {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("COIN_ID", &(self.coin_id));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
