## gecko

A simple library to access coingecko's api.


## Dependecy
```
[dependecies]
tokio = { version = "1", features = ["full"] }
gecko = { version = "0.1.6" } 
```

## Example
```rust
use gecko;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
   let gecko_client = gecko::CoinGeckoAPI::default();
   let coins_list = gecko::coins::List::required();
   let response = gecko_client(&coins_list).await.unwrap();
   println!("{:?}", response):
}
```

## Note
The testing only covers that the api endpoints are reachable (200 code). Responses are translated into a serde json values and the correctness of expected values are not tested.  

## ps
this is my first rust project so be nice :) 
