use gecko::simple;
mod generic;

const ID: &str = "ethereum";
const CONTRACT_ADDRESS: &str = "0x0D8775F648430679A709E98d2b0Cb6250d2887EF";
static VS_CURRENCY: &str = "usd";

#[tokio::test]
async fn test_price() {
    let resource = simple::Price::required(ID.to_string(), VS_CURRENCY.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_test_price() {
    let resource = simple::TokenPrice::required(
        ID.to_string(),
        CONTRACT_ADDRESS.to_string(),
        VS_CURRENCY.to_string(),
    );
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_support_currency() {
    let resource = simple::SupportedCurrency::required();
    generic::test_get(&resource).await;
}
