use gecko::derivatives;
mod generic;

static ID: &str = "bitmex";

#[tokio::test]
async fn test_derivatives() {
    let resource = derivatives::Derivatives::required();
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_exchanges() {
    let resource = derivatives::Exchanges::required();
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_info() {
    let resource = derivatives::Info::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_list() {
    let resource = derivatives::List::required();
    generic::test_get(&resource).await;
}
