use gecko::coins;
mod generic;

static ID: &str = "bitcoin";
static VS_CURRENCY: &str = "usd";

#[tokio::test]
async fn test_list() {
    let resource = coins::List::required();
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_markets() {
    let resource = coins::Markets::required(VS_CURRENCY.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_info() {
    let resource = coins::Info::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_tickers() {
    let resource = coins::Tickers::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_history() {
    let resource = coins::History::required(ID.to_string(), "10-05-2021".to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_market_chart() {
    let resource =
        coins::MarketChart::required(ID.to_string(), VS_CURRENCY.to_string(), "14".to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_market_chart_range() {
    let from: i64 = 1609480800;
    let to: i64 = 1622523600;
    let resource =
        coins::MarketChartRange::required(ID.to_string(), VS_CURRENCY.to_string(), from, to);
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_status_updates() {
    let resource = coins::StatusUpdates::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_ohlc() {
    let resource = coins::OHLC::required(ID.to_string(), VS_CURRENCY.to_string(), "14".to_string());
    generic::test_get(&resource).await;
}
