//! # `/exchange_rates`
//!
//! - [/exchange_rates](ExchangeRates)
use crate::Route;

pub struct ExchangeRates {
    endpoint: String,
}

impl ExchangeRates {
    pub fn required() -> ExchangeRates {
        ExchangeRates::default()
    }
}

impl Default for ExchangeRates {
    fn default() -> ExchangeRates {
        ExchangeRates {
            endpoint: String::from("/exchange_rates"),
        }
    }
}
impl Route for ExchangeRates {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
