//! # `/events`
//!
//! - [/events](Events)
//! - [/events/countries](Countries)
//! - [/events/types](Types)
//!
use crate::Route;

pub struct Events {
    endpoint: String,
    pub country_code: String,
    pub ev_type: String,
    pub page: i32,
    pub upcoming_events_only: bool,
    pub from_date: String, // date
    pub to_date: String,
}
pub struct Countries {
    endpoint: String,
}
pub struct Types {
    endpoint: String,
}

impl Events {
    pub fn required() -> Events {
        Events::default()
    }
}
impl Countries {
    pub fn required() -> Countries {
        Countries::default()
    }
}
impl Types {
    pub fn required() -> Types {
        Types::default()
    }
}

impl Default for Events {
    fn default() -> Events {
        Events {
            endpoint: String::from("/events"),
            country_code: String::from("US"),
            ev_type: String::from(""),
            page: 1,
            upcoming_events_only: true,
            from_date: String::from(""),
            to_date: String::from(""),
        }
    }
}
impl Default for Countries {
    fn default() -> Countries {
        Countries {
            endpoint: String::from("/events/countries"),
        }
    }
}
impl Default for Types {
    fn default() -> Types {
        Types {
            endpoint: String::from("/events/types"),
        }
    }
}

impl Route for Events {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Events = Default::default();
        let country_code = self.format_query(
            "country_code".to_string(),
            &(self.country_code),
            &(default.country_code),
        );
        let ev_type = self.format_query("ev_type".to_string(), &(self.ev_type), &(default.ev_type));
        let page = self.format_query("page".to_string(), self.page, default.page);
        let upcoming_events_only = self.format_query(
            "upcoming_events_only".to_string(),
            self.upcoming_events_only,
            default.upcoming_events_only,
        );
        let from_date = self.format_query(
            "from_date".to_string(),
            &(self.from_date),
            &(default.from_date),
        );
        let to_date = self.format_query("to_date".to_string(), &(self.to_date), &(default.to_date));

        let optional = vec![
            country_code,
            ev_type,
            page,
            upcoming_events_only,
            from_date,
            to_date,
        ];
        self.collect_query_params(optional)
    }
}
impl Route for Countries {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
impl Route for Types {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
