use gecko::exchanges;
mod generic;

static ID: &str = "sushiswap";

#[tokio::test]
async fn test_exchanges() {
    let resource = exchanges::Exchanges::required();
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_list() {
    let resource = exchanges::List::required();
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_info() {
    let resource = exchanges::Info::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_tickers() {
    let resource = exchanges::Tickers::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_status_updates() {
    let resource = exchanges::StatusUpdates::required(ID.to_string());
    generic::test_get(&resource).await;
}

#[tokio::test]
async fn test_volume_data() {
    let resource = exchanges::VolumeData::required(ID.to_string(), "14".to_string());
    generic::test_get(&resource).await;
}
