use crate::Route;

pub struct Trending {
    endpoint: String, // /search/trending
}

impl Trending {
    pub fn required() -> Trending {
        Trending::default()
    }
}

impl Default for Trending {
    fn default() -> Trending {
        Trending {
            endpoint: String::from("/search/trending"),
        }
    }
}
impl Route for Trending {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
