use crate::Route;

pub struct StatusUpdates {
    endpoint: String, // /status_updates
    pub category: String,
    pub project_type: String,
    pub per_page: i32,
    pub page: i32,
}

impl StatusUpdates {
    pub fn required() -> StatusUpdates {
        StatusUpdates::default()
    }
}

impl Default for StatusUpdates {
    fn default() -> StatusUpdates {
        StatusUpdates {
            endpoint: String::from("/status_updates"),
            category: String::from(""),
            project_type: String::from(""),
            per_page: 100,
            page: 1,
        }
    }
}
impl Route for StatusUpdates {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: StatusUpdates = Default::default();
        let category = self.format_query(
            "category".to_string(),
            &(self.category),
            &(default.category),
        );
        let project_type = self.format_query(
            "project_type".to_string(),
            &(self.project_type),
            &(default.category),
        );
        let per_page = self.format_query("per_page".to_string(), self.per_page, default.per_page);
        let page = self.format_query("page".to_string(), self.page, default.page);
        let optional = vec![category, project_type, per_page, page];
        self.collect_query_params(optional)
    }
}
