use crate::Route;

pub struct Global {
    endpoint: String, // /global
}
pub struct DeFi {
    endpoint: String,
}

impl Global {
    pub fn required() -> Global {
        Global::default()
    }
}
impl DeFi {
    pub fn required() -> DeFi {
        DeFi::default()
    }
}

impl Default for Global {
    fn default() -> Global {
        Global {
            endpoint: String::from("/global"),
        }
    }
}
impl Default for DeFi {
    fn default() -> DeFi {
        DeFi {
            endpoint: String::from("/global/decentralized_finance_defi"),
        }
    }
}

impl Route for Global {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
impl Route for DeFi {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
