use crate::Route;

pub struct Platforms {
    endpoint: String, // /finance_platforms
    pub per_page: i32,
    pub page: i32,
}
pub struct Products {
    endpoint: String, // /finance_products
    pub per_page: i32,
    pub page: i32,
    pub start_at: String, // date
    pub end_at: String,
}

impl Platforms {
    pub fn required() -> Platforms {
        Platforms::default()
    }
}
impl Products {
    pub fn required() -> Products {
        Products::default()
    }
}

impl Default for Platforms {
    fn default() -> Platforms {
        Platforms {
            endpoint: String::from("/finance_platforms"),
            per_page: 100,
            page: 1,
        }
    }
}
impl Default for Products {
    fn default() -> Products {
        Products {
            endpoint: String::from("/finance_products"),
            per_page: 100,
            page: 1,
            start_at: String::from(""),
            end_at: String::from(""),
        }
    }
}

impl Route for Platforms {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Platforms = Default::default();
        let per_page = self.format_query("per_page".to_string(), self.per_page, default.per_page);
        let page = self.format_query("page".to_string(), self.page, default.page);
        let optional = vec![per_page, page];
        self.collect_query_params(optional)
    }
}
impl Route for Products {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Products = Default::default();
        let per_page = self.format_query("per_page".to_string(), self.per_page, default.per_page);
        let page = self.format_query("page".to_string(), self.page, default.page);
        let start_at = self.format_query(
            "start_at".to_string(),
            &(self.start_at),
            &(default.start_at),
        );
        let end_at = self.format_query("end_at".to_string(), &(self.end_at), &(default.end_at));
        let optional = vec![per_page, page, start_at, end_at];
        self.collect_query_params(optional)
    }
}
