use crate::Route;

pub struct AssetPlatforms {
    endpoint: String,
}

impl AssetPlatforms {
    pub fn required() -> AssetPlatforms {
        Default::default()
    }
}

impl Default for AssetPlatforms {
    fn default() -> AssetPlatforms {
        AssetPlatforms {
            endpoint: String::from("/asset_platforms"),
        }
    }
}

impl Route for AssetPlatforms {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
