
use crate::Route;

pub struct Indexes {
    endpoint: String,                   // /indexes
    pub per_page: i32,
    pub page: i32,
}
pub struct Info {
    endpoint: String,                   // /indexes/{market_id}/{id}
    pub id: String,
    pub market_id: String
}

pub struct List {
    endpoint: String,                   // /indexes/list
} 

impl Default for Indexes {
    fn default() -> Indexes {
        Indexes {
            endpoint: String::from("/indexes"),
            per_page: 100,
            page: 1,
        }
    }
}
impl Default for Info {
    fn default() -> Info {
        Info {
            endpoint: String::from("/indexes/MARKET_ID/ID"),
            id: String::from(""),
            market_id: String::from(""),
        }
    }
}
impl Default for List {
    fn default() -> List {
        List {
            endpoint: String::from("/indexes/list"),
        }
    }
}
impl Route for Indexes {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Indexes = Default::default();
        let per_page = self.format_query("per_page".to_string(), self.per_page, default.per_page);
        let page = self.format_query("page".to_string(), self.page, default.page);
        let optional = vec![per_page, page];
        self.collect_query_params(optional)

    }
}
impl Route for Info {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("MARKET_ID", &(self.market_id)).replace("ID", &(self.id));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }

}
impl Route for List {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }

} 
