use crate::Route;

pub struct ExchangeRates {
    endpoint: String,           // /exchange_rates
}

impl Default for ExchangeRates {
    fn default() -> ExchangeRates {
        ExchangeRates {
            endpoint: String::from("/exchange_rates"),
        }
    }
}
impl Route for ExchangeRates {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
