use crate::Route;

pub struct Derivates {
    endpoint: String,               // /derivatives
    pub include_tickers: String,    // 'all' or 'expired'
}
pub struct Exchanges {
    endpoint: String,               // /derivatives/exchanges
    pub order: String,              // name_asc，name_desc，open_interest_btc_asc，open_interest_btc_desc，trade_volume_24h_btc_asc，trade_volume_24h_btc_desc
    pub per_page: i32,
    pub page: i32,
}
pub struct Info {
    endpoint: String,               // /derivatives/exchanges/{id}
    pub id: String,
    pub include_tickers: String,    // 'all' or 'expired'

}
pub struct List {
    endpoint: String,               // /derivatives/exchanges/list
}

impl Default for Derivates {
    fn default() -> Derivates {
        Derivates {
            endpoint: String::from("/derivates"),
            include_tickers: String::from("unexpired"),
        }
    }
}
impl Default for Exchanges {
    fn default() -> Exchanges {
        Exchanges {
            endpoint: String::from("/derivates/exchanges"),
            order: String::from("name_asc"), // guessed
            per_page: 100,
            page: 1,
        }
    }
}
impl Default for Info {
    fn default() -> Info {
        Info {
            endpoint: String::from("/derivates/exchanges/ID"),
            id: String::from(""),
            include_tickers: String::from("unexpired"),
        }
    }
}
impl Default for List {
    fn default() -> List {
        List {
            endpoint: String::from("/derivates/exchanges/list"),
        }
    }
}

impl Route for Derivates {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Derivates = Default::default();
        let include_tickers = self.format_query("include_tickers".to_string(), &(self.include_tickers), &(default.include_tickers));
        let optional = vec![include_tickers];
        self.collect_query_params(optional)
    }
}
impl Route for Exchanges {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        let default: Exchanges = Default::default();
        let per_page = self.format_query("per_page".to_string(), self.per_page, default.per_page);
        let page = self.format_query("page".to_string(), self.page, default.page);
        let order = self.format_query("order".to_string(), &(self.order), &(default.order));
        let optional = vec![per_page, page, order];
        self.collect_query_params(optional)
    }
}
impl Route for Info {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("ID", &(self.id));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        let default: Info = Default::default();
        let include_tickers = self.format_query("include_tickers".to_string(), &(self.include_tickers), &(default.include_tickers));
        let optional = vec![include_tickers];
        self.collect_query_params(optional)
    }
}
impl Route for List {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }

}
