
use crate::Route;


pub struct Info {
    endpoint: String,                   /// /coins/{id}/contract/{contract_address}
    pub id: String,
    pub contract_address: String,
}
pub struct MarketChart {
    endpoint: String,                   /// /coins/{id}/contract/{contract_address}/market_chart
    pub id: String,
    pub contract_address: String,
    pub vs_currency: String,
    pub days: String,
}
pub struct MarketChartRange {
    endpoint: String,                   /// /coins/{id}/contract/{contract_address}/market_chart/range                  
    pub id: String,
    pub contract_address: String,
    pub vs_currency: String,
    pub from: i64,
    pub to: i64,
}


impl Default for Info {
    fn default() -> Info {
        Info {
            endpoint: String::from("/coins/ID/contract/CONTRACT"),
            id: String::from(""),
            contract_address: String::from(""),
        }
    }
}
impl Default for MarketChart {
    fn default() -> MarketChart {
        MarketChart {
            endpoint: String::from("/coins/ID/contract/CONTRACT/market_chart"),
            id: String::from(""),
            contract_address: String::from(""),
            vs_currency: String::from(""),
            days: String::from(""),
        }
    }
}
impl Default for MarketChartRange {
    fn default() -> MarketChartRange {
        MarketChartRange {
            endpoint: String::from("/coins/ID/contract/CONTRACT/market_chart/range"),
            id: String::from(""),
            contract_address: String::from(""),
            vs_currency: String::from(""),
            from: 0,
            to: 0,
        }
    }
}


impl Route for Info {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("ID", &(self.id)).replace("CONTRACT", &(self.contract_address));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
impl Route for MarketChart {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("ID", &(self.id)).replace("CONTRACT", &(self.contract_address));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        let default: MarketChart = Default::default();
        let vs_currency = self.format_query("vs_currency".to_string(), &(self.vs_currency), &(default.vs_currency));
        let days = self.format_query("days".to_string(), &(self.days), &(default.days));
        let optional = vec![vs_currency, days];
        self.collect_query_params(optional)
    }
}
impl Route for MarketChartRange {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("ID", &(self.id)).replace("CONTRACT", &(self.contract_address));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        let default: MarketChartRange = Default::default();
        let vs_currency = self.format_query("vs_currency".to_string(), &(self.vs_currency), &(default.vs_currency));
        let from = self.format_query("from".to_string(), self.from, default.from);
        let to = self.format_query("to".to_string(), self.to, default.to);
        let optional = vec![vs_currency, from, to];
        self.collect_query_params(optional)
    }
}
