use crate::Route;

pub struct Companies {
    endpoint: String,               // /companies/public_treasury/{coin_id}
    pub coin_id: String,            // bitcoin or ethereum
}

impl Default for Companies {
    fn default() -> Companies {
        Companies {
            endpoint: String::from("/companies/public_treasury/COIN_ID"),
            coin_id: String::from(""),
        }
    }
}
impl Route for Companies {
    fn api_endpoint(&self) -> String {
        let endpoint = self.endpoint.replace("COIN_ID", &(self.coin_id));
        format!("{}", endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }

}
