
use crate::Route;

pub struct List {
    endpoint: String,                   // /coins/categories/list
}

pub struct Categories {
    endpoint: String,                   // /coin/categories
}


impl Default for List {
    fn default() -> List {
        List {
            endpoint: String::from("/coins/categories/list"),
        }
    }
}
impl Default for Categories {
    fn default() -> Categories {
        Categories {
            endpoint: String::from("/coin/categories"),
        }
    }
}


impl Route for List {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
impl Route for Categories {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
