
use crate::Route;


pub struct AssetPlatforms {
    endpoint: String,                  // /asset/platforms
}


impl Default for AssetPlatforms {
    fn default() -> AssetPlatforms {
        AssetPlatforms {
            endpoint: String::from("/asset_platforms"),
        }
    }
}
impl Route for AssetPlatforms {
    fn api_endpoint(&self) -> String {
        format!("{}", self.endpoint)
    }
    fn query_string(&self) -> String {
        String::from("")
    }
}
