use std::{
    self,
    hash::{BuildHasher, Hash},
};

use crate::collections::HashMap;

impl<K, V, S> FromIterator<(K, V)> for HashMap<K, V, S>
where
    K: Eq + Hash,
    S: BuildHasher + Default,
{
    #[inline]
    fn from_iter<T: IntoIterator<Item = (K, V)>>(iter: T) -> HashMap<K, V, S> {
        let mut map = HashMap::with_hasher(S::default());
        map.extend(iter);
        map
    }
}
