# Rust GDK3-Wayland bindings

Project site is [here](https://gtk-rs.org/).

__Rust__ bindings and wrappers for [GDK3-Wayland](https://developer.gnome.org/gdk3/),
part of [gtk3-rs](https://github.com/gtk-rs/gtk3-rs).

GDK3-Wayland __3.18__ is the lowest supported version for the underlying library.

## Minimum supported Rust version

Currently, the minimum supported Rust version is `1.56.0`.

## Documentation

 * [Rust API - Stable](https://gtk-rs.org/gtk3-rs/stable/latest/docs/gdkwayland/)
 * [Rust API - Development](https://gtk-rs.org/gtk3-rs/git/docs/gdkwayland)
 * [C API](https://developer.gnome.org/gdk3/stable/)
 * [GTK Installation instructions](https://www.gtk.org/docs/installations/)

## Using

We recommend using [crates from crates.io](https://crates.io/keywords/gtk-rs),
as [demonstrated here](https://gtk-rs.org/#using).

If you want to track the bleeding edge, use the git dependency instead:

```toml
[dependencies]
gdkwayland = { git = "https://github.com/gtk-rs/gtk3-rs.git", package = "gdkwayland" }
```

Avoid mixing versioned and git crates like this:

```toml
# This will not compile
[dependencies]
gdkwayland = "0.15"
gdkwayland = { git = "https://github.com/gtk-rs/gtk3-rs.git", package = "gdkwayland" }
```

### See Also

 * [glib](https://crates.io/crates/glib)
 * [cairo-rs](https://crates.io/crates/cairo-rs)
 * [gdk-pixbuf](https://crates.io/crates/gdk-pixbuf)
 * [gio](https://crates.io/crates/gio)
 * [pango](https://crates.io/crates/pango)

## License

__gdk_waylang__ is available under the MIT License, please refer to it.
