// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Paintable;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GdkTexture")]
    pub struct Texture(Object<ffi::GdkTexture, ffi::GdkTextureClass>) @implements Paintable;

    match fn {
        type_ => || ffi::gdk_texture_get_type(),
    }
}

impl Texture {
    #[doc(alias = "gdk_texture_new_for_pixbuf")]
    #[doc(alias = "new_for_pixbuf")]
    pub fn for_pixbuf(pixbuf: &gdk_pixbuf::Pixbuf) -> Texture {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gdk_texture_new_for_pixbuf(pixbuf.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_texture_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file<P: IsA<gio::File>>(file: &P) -> Result<Texture, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gdk_texture_new_from_file(file.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gdk_texture_new_from_resource")]
    #[doc(alias = "new_from_resource")]
    pub fn from_resource(resource_path: &str) -> Texture {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gdk_texture_new_from_resource(
                resource_path.to_glib_none().0,
            ))
        }
    }
}

pub const NONE_TEXTURE: Option<&Texture> = None;

pub trait TextureExt: 'static {
    #[doc(alias = "gdk_texture_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> i32;

    #[doc(alias = "gdk_texture_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32;

    #[doc(alias = "gdk_texture_save_to_png")]
    fn save_to_png<P: AsRef<std::path::Path>>(&self, filename: P) -> bool;
}

impl<O: IsA<Texture>> TextureExt for O {
    fn height(&self) -> i32 {
        unsafe { ffi::gdk_texture_get_height(self.as_ref().to_glib_none().0) }
    }

    fn width(&self) -> i32 {
        unsafe { ffi::gdk_texture_get_width(self.as_ref().to_glib_none().0) }
    }

    fn save_to_png<P: AsRef<std::path::Path>>(&self, filename: P) -> bool {
        unsafe {
            from_glib(ffi::gdk_texture_save_to_png(
                self.as_ref().to_glib_none().0,
                filename.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for Texture {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Texture")
    }
}
