#[doc = "Register `PWRCLKCTL` reader"]
pub struct R(crate::R<PWRCLKCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PWRCLKCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PWRCLKCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PWRCLKCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PWRCLKCTL` writer"]
pub struct W(crate::W<PWRCLKCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PWRCLKCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PWRCLKCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PWRCLKCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SUCLK` reader - Stop the USB clock"]
pub struct SUCLK_R(crate::FieldReader<bool, bool>);
impl SUCLK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SUCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUCLK` writer - Stop the USB clock"]
pub struct SUCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> SUCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `SHCLK` reader - Stop HCLK"]
pub struct SHCLK_R(crate::FieldReader<bool, bool>);
impl SHCLK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SHCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SHCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SHCLK` writer - Stop HCLK"]
pub struct SHCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> SHCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Stop the USB clock"]
    #[inline(always)]
    pub fn suclk(&self) -> SUCLK_R {
        SUCLK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Stop HCLK"]
    #[inline(always)]
    pub fn shclk(&self) -> SHCLK_R {
        SHCLK_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Stop the USB clock"]
    #[inline(always)]
    pub fn suclk(&mut self) -> SUCLK_W {
        SUCLK_W { w: self }
    }
    #[doc = "Bit 1 - Stop HCLK"]
    #[inline(always)]
    pub fn shclk(&mut self) -> SHCLK_W {
        SHCLK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "power and clock gating control register (PWRCLKCTL)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pwrclkctl](index.html) module"]
pub struct PWRCLKCTL_SPEC;
impl crate::RegisterSpec for PWRCLKCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [pwrclkctl::R](R) reader structure"]
impl crate::Readable for PWRCLKCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pwrclkctl::W](W) writer structure"]
impl crate::Writable for PWRCLKCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PWRCLKCTL to value 0"]
impl crate::Resettable for PWRCLKCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
