#[doc = "Register `HCH6INTEN` reader"]
pub struct R(crate::R<HCH6INTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HCH6INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<HCH6INTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<HCH6INTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `HCH6INTEN` writer"]
pub struct W(crate::W<HCH6INTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<HCH6INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<HCH6INTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<HCH6INTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TFIE` reader - Transfer completed interrupt enable"]
pub struct TFIE_R(crate::FieldReader<bool, bool>);
impl TFIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFIE` writer - Transfer completed interrupt enable"]
pub struct TFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TFIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `CHIE` reader - Channel halted interrupt enable"]
pub struct CHIE_R(crate::FieldReader<bool, bool>);
impl CHIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CHIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CHIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CHIE` writer - Channel halted interrupt enable"]
pub struct CHIE_W<'a> {
    w: &'a mut W,
}
impl<'a> CHIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `STALLIE` reader - STALL interrupt enable"]
pub struct STALLIE_R(crate::FieldReader<bool, bool>);
impl STALLIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        STALLIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STALLIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STALLIE` writer - STALL interrupt enable"]
pub struct STALLIE_W<'a> {
    w: &'a mut W,
}
impl<'a> STALLIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `NAKIE` reader - NAK interrupt enable"]
pub struct NAKIE_R(crate::FieldReader<bool, bool>);
impl NAKIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NAKIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NAKIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NAKIE` writer - NAK interrupt enable"]
pub struct NAKIE_W<'a> {
    w: &'a mut W,
}
impl<'a> NAKIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ACKIE` reader - ACK interrupt enable"]
pub struct ACKIE_R(crate::FieldReader<bool, bool>);
impl ACKIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ACKIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACKIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACKIE` writer - ACK interrupt enable"]
pub struct ACKIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ACKIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `USBERIE` reader - USB bus error interrupt enable"]
pub struct USBERIE_R(crate::FieldReader<bool, bool>);
impl USBERIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        USBERIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USBERIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBERIE` writer - USB bus error interrupt enable"]
pub struct USBERIE_W<'a> {
    w: &'a mut W,
}
impl<'a> USBERIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `BBERIE` reader - Babble error interrupt enable"]
pub struct BBERIE_R(crate::FieldReader<bool, bool>);
impl BBERIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        BBERIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BBERIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BBERIE` writer - Babble error interrupt enable"]
pub struct BBERIE_W<'a> {
    w: &'a mut W,
}
impl<'a> BBERIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `REQOVRIE` reader - request queue overrun interrupt enable"]
pub struct REQOVRIE_R(crate::FieldReader<bool, bool>);
impl REQOVRIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REQOVRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REQOVRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REQOVRIE` writer - request queue overrun interrupt enable"]
pub struct REQOVRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> REQOVRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `DTERIE` reader - Data toggle error interrupt enable"]
pub struct DTERIE_R(crate::FieldReader<bool, bool>);
impl DTERIE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DTERIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTERIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTERIE` writer - Data toggle error interrupt enable"]
pub struct DTERIE_W<'a> {
    w: &'a mut W,
}
impl<'a> DTERIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transfer completed interrupt enable"]
    #[inline(always)]
    pub fn tfie(&self) -> TFIE_R {
        TFIE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Channel halted interrupt enable"]
    #[inline(always)]
    pub fn chie(&self) -> CHIE_R {
        CHIE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - STALL interrupt enable"]
    #[inline(always)]
    pub fn stallie(&self) -> STALLIE_R {
        STALLIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - NAK interrupt enable"]
    #[inline(always)]
    pub fn nakie(&self) -> NAKIE_R {
        NAKIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - ACK interrupt enable"]
    #[inline(always)]
    pub fn ackie(&self) -> ACKIE_R {
        ACKIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 7 - USB bus error interrupt enable"]
    #[inline(always)]
    pub fn usberie(&self) -> USBERIE_R {
        USBERIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Babble error interrupt enable"]
    #[inline(always)]
    pub fn bberie(&self) -> BBERIE_R {
        BBERIE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - request queue overrun interrupt enable"]
    #[inline(always)]
    pub fn reqovrie(&self) -> REQOVRIE_R {
        REQOVRIE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Data toggle error interrupt enable"]
    #[inline(always)]
    pub fn dterie(&self) -> DTERIE_R {
        DTERIE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transfer completed interrupt enable"]
    #[inline(always)]
    pub fn tfie(&mut self) -> TFIE_W {
        TFIE_W { w: self }
    }
    #[doc = "Bit 1 - Channel halted interrupt enable"]
    #[inline(always)]
    pub fn chie(&mut self) -> CHIE_W {
        CHIE_W { w: self }
    }
    #[doc = "Bit 3 - STALL interrupt enable"]
    #[inline(always)]
    pub fn stallie(&mut self) -> STALLIE_W {
        STALLIE_W { w: self }
    }
    #[doc = "Bit 4 - NAK interrupt enable"]
    #[inline(always)]
    pub fn nakie(&mut self) -> NAKIE_W {
        NAKIE_W { w: self }
    }
    #[doc = "Bit 5 - ACK interrupt enable"]
    #[inline(always)]
    pub fn ackie(&mut self) -> ACKIE_W {
        ACKIE_W { w: self }
    }
    #[doc = "Bit 7 - USB bus error interrupt enable"]
    #[inline(always)]
    pub fn usberie(&mut self) -> USBERIE_W {
        USBERIE_W { w: self }
    }
    #[doc = "Bit 8 - Babble error interrupt enable"]
    #[inline(always)]
    pub fn bberie(&mut self) -> BBERIE_W {
        BBERIE_W { w: self }
    }
    #[doc = "Bit 9 - request queue overrun interrupt enable"]
    #[inline(always)]
    pub fn reqovrie(&mut self) -> REQOVRIE_W {
        REQOVRIE_W { w: self }
    }
    #[doc = "Bit 10 - Data toggle error interrupt enable"]
    #[inline(always)]
    pub fn dterie(&mut self) -> DTERIE_W {
        DTERIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "host channel-6 interrupt enable register (HCH6INTEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [hch6inten](index.html) module"]
pub struct HCH6INTEN_SPEC;
impl crate::RegisterSpec for HCH6INTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [hch6inten::R](R) reader structure"]
impl crate::Readable for HCH6INTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [hch6inten::W](W) writer structure"]
impl crate::Writable for HCH6INTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets HCH6INTEN to value 0"]
impl crate::Resettable for HCH6INTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
