#[doc = "Register `HPTFLEN` reader"]
pub struct R(crate::R<HPTFLEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HPTFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<HPTFLEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<HPTFLEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `HPTFLEN` writer"]
pub struct W(crate::W<HPTFLEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<HPTFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<HPTFLEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<HPTFLEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `HPTXFSAR` reader - Host periodic TxFIFO start address"]
pub struct HPTXFSAR_R(crate::FieldReader<u16, u16>);
impl HPTXFSAR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        HPTXFSAR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HPTXFSAR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HPTXFSAR` writer - Host periodic TxFIFO start address"]
pub struct HPTXFSAR_W<'a> {
    w: &'a mut W,
}
impl<'a> HPTXFSAR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
#[doc = "Field `HPTXFD` reader - Host periodic TxFIFO depth"]
pub struct HPTXFD_R(crate::FieldReader<u16, u16>);
impl HPTXFD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        HPTXFD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HPTXFD_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HPTXFD` writer - Host periodic TxFIFO depth"]
pub struct HPTXFD_W<'a> {
    w: &'a mut W,
}
impl<'a> HPTXFD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:15 - Host periodic TxFIFO start address"]
    #[inline(always)]
    pub fn hptxfsar(&self) -> HPTXFSAR_R {
        HPTXFSAR_R::new((self.bits & 0xffff) as u16)
    }
    #[doc = "Bits 16:31 - Host periodic TxFIFO depth"]
    #[inline(always)]
    pub fn hptxfd(&self) -> HPTXFD_R {
        HPTXFD_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:15 - Host periodic TxFIFO start address"]
    #[inline(always)]
    pub fn hptxfsar(&mut self) -> HPTXFSAR_W {
        HPTXFSAR_W { w: self }
    }
    #[doc = "Bits 16:31 - Host periodic TxFIFO depth"]
    #[inline(always)]
    pub fn hptxfd(&mut self) -> HPTXFD_W {
        HPTXFD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Host periodic transmit FIFO length register (HPTFLEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [hptflen](index.html) module"]
pub struct HPTFLEN_SPEC;
impl crate::RegisterSpec for HPTFLEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [hptflen::R](R) reader structure"]
impl crate::Readable for HPTFLEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [hptflen::W](W) writer structure"]
impl crate::Writable for HPTFLEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets HPTFLEN to value 0x0200_0600"]
impl crate::Resettable for HPTFLEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0200_0600
    }
}
