#[doc = "Register `HNPTFQSTAT` reader"]
pub struct R(crate::R<HNPTFQSTAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HNPTFQSTAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<HNPTFQSTAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<HNPTFQSTAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `NPTXFS` reader - Non-periodic TxFIFO space"]
pub struct NPTXFS_R(crate::FieldReader<u16, u16>);
impl NPTXFS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        NPTXFS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NPTXFS_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NPTXRQS` reader - Non-periodic transmit request queue space"]
pub struct NPTXRQS_R(crate::FieldReader<u8, u8>);
impl NPTXRQS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NPTXRQS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NPTXRQS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NPTXRQTOP` reader - Top of the non-periodic transmit request queue"]
pub struct NPTXRQTOP_R(crate::FieldReader<u8, u8>);
impl NPTXRQTOP_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        NPTXRQTOP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NPTXRQTOP_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 0:15 - Non-periodic TxFIFO space"]
    #[inline(always)]
    pub fn nptxfs(&self) -> NPTXFS_R {
        NPTXFS_R::new((self.bits & 0xffff) as u16)
    }
    #[doc = "Bits 16:23 - Non-periodic transmit request queue space"]
    #[inline(always)]
    pub fn nptxrqs(&self) -> NPTXRQS_R {
        NPTXRQS_R::new(((self.bits >> 16) & 0xff) as u8)
    }
    #[doc = "Bits 24:30 - Top of the non-periodic transmit request queue"]
    #[inline(always)]
    pub fn nptxrqtop(&self) -> NPTXRQTOP_R {
        NPTXRQTOP_R::new(((self.bits >> 24) & 0x7f) as u8)
    }
}
#[doc = "Host non-periodic transmit FIFO/queue status register (HNPTFQSTAT)\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [hnptfqstat](index.html) module"]
pub struct HNPTFQSTAT_SPEC;
impl crate::RegisterSpec for HNPTFQSTAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [hnptfqstat::R](R) reader structure"]
impl crate::Readable for HNPTFQSTAT_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets HNPTFQSTAT to value 0x0008_0200"]
impl crate::Resettable for HNPTFQSTAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0008_0200
    }
}
