#[doc = "Register `GUSBCS` reader"]
pub struct R(crate::R<GUSBCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GUSBCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GUSBCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GUSBCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GUSBCS` writer"]
pub struct W(crate::W<GUSBCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GUSBCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GUSBCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GUSBCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOC` reader - Timeout calibration"]
pub struct TOC_R(crate::FieldReader<u8, u8>);
impl TOC_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        TOC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOC` writer - Timeout calibration"]
pub struct TOC_W<'a> {
    w: &'a mut W,
}
impl<'a> TOC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u32 & 0x07);
        self.w
    }
}
#[doc = "Field `SRPCEN` reader - SRP capability enable"]
pub struct SRPCEN_R(crate::FieldReader<bool, bool>);
impl SRPCEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SRPCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRPCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRPCEN` writer - SRP capability enable"]
pub struct SRPCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SRPCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `HNPCEN` reader - HNP capability enable"]
pub struct HNPCEN_R(crate::FieldReader<bool, bool>);
impl HNPCEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HNPCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HNPCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HNPCEN` writer - HNP capability enable"]
pub struct HNPCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> HNPCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `UTT` reader - USB turnaround time"]
pub struct UTT_R(crate::FieldReader<u8, u8>);
impl UTT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        UTT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UTT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UTT` writer - USB turnaround time"]
pub struct UTT_W<'a> {
    w: &'a mut W,
}
impl<'a> UTT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 10)) | ((value as u32 & 0x0f) << 10);
        self.w
    }
}
#[doc = "Field `FHM` reader - Force host mode"]
pub struct FHM_R(crate::FieldReader<bool, bool>);
impl FHM_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FHM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FHM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FHM` writer - Force host mode"]
pub struct FHM_W<'a> {
    w: &'a mut W,
}
impl<'a> FHM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `FDM` reader - Force device mode"]
pub struct FDM_R(crate::FieldReader<bool, bool>);
impl FDM_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FDM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FDM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FDM` writer - Force device mode"]
pub struct FDM_W<'a> {
    w: &'a mut W,
}
impl<'a> FDM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Timeout calibration"]
    #[inline(always)]
    pub fn toc(&self) -> TOC_R {
        TOC_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 8 - SRP capability enable"]
    #[inline(always)]
    pub fn srpcen(&self) -> SRPCEN_R {
        SRPCEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - HNP capability enable"]
    #[inline(always)]
    pub fn hnpcen(&self) -> HNPCEN_R {
        HNPCEN_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bits 10:13 - USB turnaround time"]
    #[inline(always)]
    pub fn utt(&self) -> UTT_R {
        UTT_R::new(((self.bits >> 10) & 0x0f) as u8)
    }
    #[doc = "Bit 29 - Force host mode"]
    #[inline(always)]
    pub fn fhm(&self) -> FHM_R {
        FHM_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - Force device mode"]
    #[inline(always)]
    pub fn fdm(&self) -> FDM_R {
        FDM_R::new(((self.bits >> 30) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Timeout calibration"]
    #[inline(always)]
    pub fn toc(&mut self) -> TOC_W {
        TOC_W { w: self }
    }
    #[doc = "Bit 8 - SRP capability enable"]
    #[inline(always)]
    pub fn srpcen(&mut self) -> SRPCEN_W {
        SRPCEN_W { w: self }
    }
    #[doc = "Bit 9 - HNP capability enable"]
    #[inline(always)]
    pub fn hnpcen(&mut self) -> HNPCEN_W {
        HNPCEN_W { w: self }
    }
    #[doc = "Bits 10:13 - USB turnaround time"]
    #[inline(always)]
    pub fn utt(&mut self) -> UTT_W {
        UTT_W { w: self }
    }
    #[doc = "Bit 29 - Force host mode"]
    #[inline(always)]
    pub fn fhm(&mut self) -> FHM_W {
        FHM_W { w: self }
    }
    #[doc = "Bit 30 - Force device mode"]
    #[inline(always)]
    pub fn fdm(&mut self) -> FDM_W {
        FDM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Global USB control and status register (OTG_FS_GUSBCSR)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gusbcs](index.html) module"]
pub struct GUSBCS_SPEC;
impl crate::RegisterSpec for GUSBCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gusbcs::R](R) reader structure"]
impl crate::Readable for GUSBCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gusbcs::W](W) writer structure"]
impl crate::Writable for GUSBCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GUSBCS to value 0x0a80"]
impl crate::Resettable for GUSBCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0a80
    }
}
