#[doc = "Register `GRSTATR_Device` reader"]
pub struct R(crate::R<GRSTATR_DEVICE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GRSTATR_DEVICE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GRSTATR_DEVICE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GRSTATR_DEVICE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `EPNUM` reader - Endpoint number"]
pub struct EPNUM_R(crate::FieldReader<u8, u8>);
impl EPNUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        EPNUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPNUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BCOUNT` reader - Byte count"]
pub struct BCOUNT_R(crate::FieldReader<u16, u16>);
impl BCOUNT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        BCOUNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BCOUNT_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DPID` reader - Data PID"]
pub struct DPID_R(crate::FieldReader<u8, u8>);
impl DPID_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        DPID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DPID_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RPCKST` reader - Recieve packet status"]
pub struct RPCKST_R(crate::FieldReader<u8, u8>);
impl RPCKST_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        RPCKST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RPCKST_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 0:3 - Endpoint number"]
    #[inline(always)]
    pub fn epnum(&self) -> EPNUM_R {
        EPNUM_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:14 - Byte count"]
    #[inline(always)]
    pub fn bcount(&self) -> BCOUNT_R {
        BCOUNT_R::new(((self.bits >> 4) & 0x07ff) as u16)
    }
    #[doc = "Bits 15:16 - Data PID"]
    #[inline(always)]
    pub fn dpid(&self) -> DPID_R {
        DPID_R::new(((self.bits >> 15) & 0x03) as u8)
    }
    #[doc = "Bits 17:20 - Recieve packet status"]
    #[inline(always)]
    pub fn rpckst(&self) -> RPCKST_R {
        RPCKST_R::new(((self.bits >> 17) & 0x0f) as u8)
    }
}
#[doc = "Global Receive status read(Device mode)\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [grstatr_device](index.html) module"]
pub struct GRSTATR_DEVICE_SPEC;
impl crate::RegisterSpec for GRSTATR_DEVICE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [grstatr_device::R](R) reader structure"]
impl crate::Readable for GRSTATR_DEVICE_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets GRSTATR_Device to value 0"]
impl crate::Resettable for GRSTATR_DEVICE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
