#[doc = "Register `GOTGINTF` reader"]
pub struct R(crate::R<GOTGINTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GOTGINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GOTGINTF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GOTGINTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GOTGINTF` writer"]
pub struct W(crate::W<GOTGINTF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GOTGINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GOTGINTF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GOTGINTF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SESEND` reader - Session end"]
pub struct SESEND_R(crate::FieldReader<bool, bool>);
impl SESEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SESEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SESEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SESEND` writer - Session end"]
pub struct SESEND_W<'a> {
    w: &'a mut W,
}
impl<'a> SESEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `SRPEND` reader - Session request success status change"]
pub struct SRPEND_R(crate::FieldReader<bool, bool>);
impl SRPEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SRPEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRPEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRPEND` writer - Session request success status change"]
pub struct SRPEND_W<'a> {
    w: &'a mut W,
}
impl<'a> SRPEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `HNPEND` reader - HNP end"]
pub struct HNPEND_R(crate::FieldReader<bool, bool>);
impl HNPEND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HNPEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HNPEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HNPEND` writer - HNP end"]
pub struct HNPEND_W<'a> {
    w: &'a mut W,
}
impl<'a> HNPEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `HNPDET` reader - Host negotiation request detected"]
pub struct HNPDET_R(crate::FieldReader<bool, bool>);
impl HNPDET_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HNPDET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HNPDET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HNPDET` writer - Host negotiation request detected"]
pub struct HNPDET_W<'a> {
    w: &'a mut W,
}
impl<'a> HNPDET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `ADTO` reader - A-device timeout"]
pub struct ADTO_R(crate::FieldReader<bool, bool>);
impl ADTO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ADTO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADTO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADTO` writer - A-device timeout"]
pub struct ADTO_W<'a> {
    w: &'a mut W,
}
impl<'a> ADTO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `DF` reader - Debounce finish"]
pub struct DF_R(crate::FieldReader<bool, bool>);
impl DF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DF` writer - Debounce finish"]
pub struct DF_W<'a> {
    w: &'a mut W,
}
impl<'a> DF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - Session end"]
    #[inline(always)]
    pub fn sesend(&self) -> SESEND_R {
        SESEND_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Session request success status change"]
    #[inline(always)]
    pub fn srpend(&self) -> SRPEND_R {
        SRPEND_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - HNP end"]
    #[inline(always)]
    pub fn hnpend(&self) -> HNPEND_R {
        HNPEND_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Host negotiation request detected"]
    #[inline(always)]
    pub fn hnpdet(&self) -> HNPDET_R {
        HNPDET_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - A-device timeout"]
    #[inline(always)]
    pub fn adto(&self) -> ADTO_R {
        ADTO_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Debounce finish"]
    #[inline(always)]
    pub fn df(&self) -> DF_R {
        DF_R::new(((self.bits >> 19) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Session end"]
    #[inline(always)]
    pub fn sesend(&mut self) -> SESEND_W {
        SESEND_W { w: self }
    }
    #[doc = "Bit 8 - Session request success status change"]
    #[inline(always)]
    pub fn srpend(&mut self) -> SRPEND_W {
        SRPEND_W { w: self }
    }
    #[doc = "Bit 9 - HNP end"]
    #[inline(always)]
    pub fn hnpend(&mut self) -> HNPEND_W {
        HNPEND_W { w: self }
    }
    #[doc = "Bit 17 - Host negotiation request detected"]
    #[inline(always)]
    pub fn hnpdet(&mut self) -> HNPDET_W {
        HNPDET_W { w: self }
    }
    #[doc = "Bit 18 - A-device timeout"]
    #[inline(always)]
    pub fn adto(&mut self) -> ADTO_W {
        ADTO_W { w: self }
    }
    #[doc = "Bit 19 - Debounce finish"]
    #[inline(always)]
    pub fn df(&mut self) -> DF_W {
        DF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Global OTG interrupt flag register (USBFS_GOTGINTF)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gotgintf](index.html) module"]
pub struct GOTGINTF_SPEC;
impl crate::RegisterSpec for GOTGINTF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gotgintf::R](R) reader structure"]
impl crate::Readable for GOTGINTF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gotgintf::W](W) writer structure"]
impl crate::Writable for GOTGINTF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GOTGINTF to value 0"]
impl crate::Resettable for GOTGINTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
