#[doc = "Register `GOTGCS` reader"]
pub struct R(crate::R<GOTGCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GOTGCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GOTGCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GOTGCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GOTGCS` writer"]
pub struct W(crate::W<GOTGCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GOTGCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GOTGCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GOTGCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SRPS` reader - SRP success"]
pub struct SRPS_R(crate::FieldReader<bool, bool>);
impl SRPS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SRPS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRPS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRPREQ` reader - SRP request"]
pub struct SRPREQ_R(crate::FieldReader<bool, bool>);
impl SRPREQ_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SRPREQ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SRPREQ_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SRPREQ` writer - SRP request"]
pub struct SRPREQ_W<'a> {
    w: &'a mut W,
}
impl<'a> SRPREQ_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `HNPS` reader - Host success"]
pub struct HNPS_R(crate::FieldReader<bool, bool>);
impl HNPS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HNPS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HNPS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HNPREQ` reader - HNP request"]
pub struct HNPREQ_R(crate::FieldReader<bool, bool>);
impl HNPREQ_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HNPREQ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HNPREQ_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HNPREQ` writer - HNP request"]
pub struct HNPREQ_W<'a> {
    w: &'a mut W,
}
impl<'a> HNPREQ_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `HHNPEN` reader - Host HNP enable"]
pub struct HHNPEN_R(crate::FieldReader<bool, bool>);
impl HHNPEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HHNPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HHNPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HHNPEN` writer - Host HNP enable"]
pub struct HHNPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> HHNPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `DHNPEN` reader - Device HNP enabled"]
pub struct DHNPEN_R(crate::FieldReader<bool, bool>);
impl DHNPEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DHNPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DHNPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DHNPEN` writer - Device HNP enabled"]
pub struct DHNPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DHNPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `IDPS` reader - ID pin status"]
pub struct IDPS_R(crate::FieldReader<bool, bool>);
impl IDPS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IDPS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IDPS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DI` reader - Debounce interval"]
pub struct DI_R(crate::FieldReader<bool, bool>);
impl DI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ASV` reader - A-session valid"]
pub struct ASV_R(crate::FieldReader<bool, bool>);
impl ASV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ASV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ASV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BSV` reader - B-session valid"]
pub struct BSV_R(crate::FieldReader<bool, bool>);
impl BSV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        BSV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BSV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 0 - SRP success"]
    #[inline(always)]
    pub fn srps(&self) -> SRPS_R {
        SRPS_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - SRP request"]
    #[inline(always)]
    pub fn srpreq(&self) -> SRPREQ_R {
        SRPREQ_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Host success"]
    #[inline(always)]
    pub fn hnps(&self) -> HNPS_R {
        HNPS_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - HNP request"]
    #[inline(always)]
    pub fn hnpreq(&self) -> HNPREQ_R {
        HNPREQ_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Host HNP enable"]
    #[inline(always)]
    pub fn hhnpen(&self) -> HHNPEN_R {
        HHNPEN_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Device HNP enabled"]
    #[inline(always)]
    pub fn dhnpen(&self) -> DHNPEN_R {
        DHNPEN_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 16 - ID pin status"]
    #[inline(always)]
    pub fn idps(&self) -> IDPS_R {
        IDPS_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Debounce interval"]
    #[inline(always)]
    pub fn di(&self) -> DI_R {
        DI_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - A-session valid"]
    #[inline(always)]
    pub fn asv(&self) -> ASV_R {
        ASV_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - B-session valid"]
    #[inline(always)]
    pub fn bsv(&self) -> BSV_R {
        BSV_R::new(((self.bits >> 19) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - SRP request"]
    #[inline(always)]
    pub fn srpreq(&mut self) -> SRPREQ_W {
        SRPREQ_W { w: self }
    }
    #[doc = "Bit 9 - HNP request"]
    #[inline(always)]
    pub fn hnpreq(&mut self) -> HNPREQ_W {
        HNPREQ_W { w: self }
    }
    #[doc = "Bit 10 - Host HNP enable"]
    #[inline(always)]
    pub fn hhnpen(&mut self) -> HHNPEN_W {
        HHNPEN_W { w: self }
    }
    #[doc = "Bit 11 - Device HNP enabled"]
    #[inline(always)]
    pub fn dhnpen(&mut self) -> DHNPEN_W {
        DHNPEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Global OTG control and status register (USBFS_GOTGCS)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gotgcs](index.html) module"]
pub struct GOTGCS_SPEC;
impl crate::RegisterSpec for GOTGCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gotgcs::R](R) reader structure"]
impl crate::Readable for GOTGCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gotgcs::W](W) writer structure"]
impl crate::Writable for GOTGCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GOTGCS to value 0x0800"]
impl crate::Resettable for GOTGCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0800
    }
}
