#[doc = "Register `GINTF` reader"]
pub struct R(crate::R<GINTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GINTF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GINTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GINTF` writer"]
pub struct W(crate::W<GINTF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GINTF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GINTF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `COPM` reader - Current operation mode"]
pub struct COPM_R(crate::FieldReader<bool, bool>);
impl COPM_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        COPM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COPM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MFIF` reader - Mode fault interrupt flag"]
pub struct MFIF_R(crate::FieldReader<bool, bool>);
impl MFIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        MFIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MFIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MFIF` writer - Mode fault interrupt flag"]
pub struct MFIF_W<'a> {
    w: &'a mut W,
}
impl<'a> MFIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OTGIF` reader - OTG interrupt flag"]
pub struct OTGIF_R(crate::FieldReader<bool, bool>);
impl OTGIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        OTGIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OTGIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOF` reader - Start of frame"]
pub struct SOF_R(crate::FieldReader<bool, bool>);
impl SOF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SOF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOF` writer - Start of frame"]
pub struct SOF_W<'a> {
    w: &'a mut W,
}
impl<'a> SOF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXFNEIF` reader - RxFIFO non-empty interrupt flag"]
pub struct RXFNEIF_R(crate::FieldReader<bool, bool>);
impl RXFNEIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXFNEIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXFNEIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NPTXFEIF` reader - Non-periodic TxFIFO empty interrupt flag"]
pub struct NPTXFEIF_R(crate::FieldReader<bool, bool>);
impl NPTXFEIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        NPTXFEIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NPTXFEIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GNPINAK` reader - Global Non-Periodic IN NAK effective"]
pub struct GNPINAK_R(crate::FieldReader<bool, bool>);
impl GNPINAK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        GNPINAK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GNPINAK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GONAK` reader - Global OUT NAK effective"]
pub struct GONAK_R(crate::FieldReader<bool, bool>);
impl GONAK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        GONAK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GONAK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ESP` reader - Early suspend"]
pub struct ESP_R(crate::FieldReader<bool, bool>);
impl ESP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ESP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ESP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ESP` writer - Early suspend"]
pub struct ESP_W<'a> {
    w: &'a mut W,
}
impl<'a> ESP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `SP` reader - USB suspend"]
pub struct SP_R(crate::FieldReader<bool, bool>);
impl SP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SP` writer - USB suspend"]
pub struct SP_W<'a> {
    w: &'a mut W,
}
impl<'a> SP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `RST` reader - USB reset"]
pub struct RST_R(crate::FieldReader<bool, bool>);
impl RST_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RST` writer - USB reset"]
pub struct RST_W<'a> {
    w: &'a mut W,
}
impl<'a> RST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `ENUMF` reader - Enumeration finished"]
pub struct ENUMF_R(crate::FieldReader<bool, bool>);
impl ENUMF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ENUMF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENUMF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENUMF` writer - Enumeration finished"]
pub struct ENUMF_W<'a> {
    w: &'a mut W,
}
impl<'a> ENUMF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `ISOOPDIF` reader - Isochronous OUT packet dropped interrupt"]
pub struct ISOOPDIF_R(crate::FieldReader<bool, bool>);
impl ISOOPDIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ISOOPDIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISOOPDIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISOOPDIF` writer - Isochronous OUT packet dropped interrupt"]
pub struct ISOOPDIF_W<'a> {
    w: &'a mut W,
}
impl<'a> ISOOPDIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `EOPFIF` reader - End of periodic frame interrupt flag"]
pub struct EOPFIF_R(crate::FieldReader<bool, bool>);
impl EOPFIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EOPFIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EOPFIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EOPFIF` writer - End of periodic frame interrupt flag"]
pub struct EOPFIF_W<'a> {
    w: &'a mut W,
}
impl<'a> EOPFIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `IEPIF` reader - IN endpoint interrupt flag"]
pub struct IEPIF_R(crate::FieldReader<bool, bool>);
impl IEPIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IEPIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OEPIF` reader - OUT endpoint interrupt flag"]
pub struct OEPIF_R(crate::FieldReader<bool, bool>);
impl OEPIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        OEPIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OEPIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISOINCIF` reader - Isochronous IN transfer Not Complete Interrupt Flag"]
pub struct ISOINCIF_R(crate::FieldReader<bool, bool>);
impl ISOINCIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ISOINCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ISOINCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ISOINCIF` writer - Isochronous IN transfer Not Complete Interrupt Flag"]
pub struct ISOINCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> ISOINCIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `PXNCIF_ISOONCIF` reader - periodic transfer not complete interrupt flag(Host mode)/isochronous OUT transfer not complete interrupt flag(Device mode)"]
pub struct PXNCIF_ISOONCIF_R(crate::FieldReader<bool, bool>);
impl PXNCIF_ISOONCIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PXNCIF_ISOONCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PXNCIF_ISOONCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PXNCIF_ISOONCIF` writer - periodic transfer not complete interrupt flag(Host mode)/isochronous OUT transfer not complete interrupt flag(Device mode)"]
pub struct PXNCIF_ISOONCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> PXNCIF_ISOONCIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `HPIF` reader - Host port interrupt flag"]
pub struct HPIF_R(crate::FieldReader<bool, bool>);
impl HPIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HPIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HPIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HCIF` reader - Host channels interrupt flag"]
pub struct HCIF_R(crate::FieldReader<bool, bool>);
impl HCIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PTXFEIF` reader - Periodic TxFIFO empty interrupt flag"]
pub struct PTXFEIF_R(crate::FieldReader<bool, bool>);
impl PTXFEIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PTXFEIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PTXFEIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IDPSC` reader - ID pin status change"]
pub struct IDPSC_R(crate::FieldReader<bool, bool>);
impl IDPSC_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IDPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IDPSC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IDPSC` writer - ID pin status change"]
pub struct IDPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> IDPSC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `DISCIF` reader - Disconnect interrupt flag"]
pub struct DISCIF_R(crate::FieldReader<bool, bool>);
impl DISCIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DISCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DISCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DISCIF` writer - Disconnect interrupt flag"]
pub struct DISCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> DISCIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `SESIF` reader - Session interrupt flag"]
pub struct SESIF_R(crate::FieldReader<bool, bool>);
impl SESIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SESIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SESIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SESIF` writer - Session interrupt flag"]
pub struct SESIF_W<'a> {
    w: &'a mut W,
}
impl<'a> SESIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `WKUPIF` reader - Wakeup interrupt flag"]
pub struct WKUPIF_R(crate::FieldReader<bool, bool>);
impl WKUPIF_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WKUPIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WKUPIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WKUPIF` writer - Wakeup interrupt flag"]
pub struct WKUPIF_W<'a> {
    w: &'a mut W,
}
impl<'a> WKUPIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Current operation mode"]
    #[inline(always)]
    pub fn copm(&self) -> COPM_R {
        COPM_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Mode fault interrupt flag"]
    #[inline(always)]
    pub fn mfif(&self) -> MFIF_R {
        MFIF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - OTG interrupt flag"]
    #[inline(always)]
    pub fn otgif(&self) -> OTGIF_R {
        OTGIF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Start of frame"]
    #[inline(always)]
    pub fn sof(&self) -> SOF_R {
        SOF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - RxFIFO non-empty interrupt flag"]
    #[inline(always)]
    pub fn rxfneif(&self) -> RXFNEIF_R {
        RXFNEIF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Non-periodic TxFIFO empty interrupt flag"]
    #[inline(always)]
    pub fn nptxfeif(&self) -> NPTXFEIF_R {
        NPTXFEIF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Global Non-Periodic IN NAK effective"]
    #[inline(always)]
    pub fn gnpinak(&self) -> GNPINAK_R {
        GNPINAK_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Global OUT NAK effective"]
    #[inline(always)]
    pub fn gonak(&self) -> GONAK_R {
        GONAK_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Early suspend"]
    #[inline(always)]
    pub fn esp(&self) -> ESP_R {
        ESP_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - USB suspend"]
    #[inline(always)]
    pub fn sp(&self) -> SP_R {
        SP_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - USB reset"]
    #[inline(always)]
    pub fn rst(&self) -> RST_R {
        RST_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Enumeration finished"]
    #[inline(always)]
    pub fn enumf(&self) -> ENUMF_R {
        ENUMF_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Isochronous OUT packet dropped interrupt"]
    #[inline(always)]
    pub fn isoopdif(&self) -> ISOOPDIF_R {
        ISOOPDIF_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - End of periodic frame interrupt flag"]
    #[inline(always)]
    pub fn eopfif(&self) -> EOPFIF_R {
        EOPFIF_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 18 - IN endpoint interrupt flag"]
    #[inline(always)]
    pub fn iepif(&self) -> IEPIF_R {
        IEPIF_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - OUT endpoint interrupt flag"]
    #[inline(always)]
    pub fn oepif(&self) -> OEPIF_R {
        OEPIF_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Isochronous IN transfer Not Complete Interrupt Flag"]
    #[inline(always)]
    pub fn isoincif(&self) -> ISOINCIF_R {
        ISOINCIF_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - periodic transfer not complete interrupt flag(Host mode)/isochronous OUT transfer not complete interrupt flag(Device mode)"]
    #[inline(always)]
    pub fn pxncif_isooncif(&self) -> PXNCIF_ISOONCIF_R {
        PXNCIF_ISOONCIF_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Host port interrupt flag"]
    #[inline(always)]
    pub fn hpif(&self) -> HPIF_R {
        HPIF_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Host channels interrupt flag"]
    #[inline(always)]
    pub fn hcif(&self) -> HCIF_R {
        HCIF_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Periodic TxFIFO empty interrupt flag"]
    #[inline(always)]
    pub fn ptxfeif(&self) -> PTXFEIF_R {
        PTXFEIF_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 28 - ID pin status change"]
    #[inline(always)]
    pub fn idpsc(&self) -> IDPSC_R {
        IDPSC_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 29 - Disconnect interrupt flag"]
    #[inline(always)]
    pub fn discif(&self) -> DISCIF_R {
        DISCIF_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - Session interrupt flag"]
    #[inline(always)]
    pub fn sesif(&self) -> SESIF_R {
        SESIF_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - Wakeup interrupt flag"]
    #[inline(always)]
    pub fn wkupif(&self) -> WKUPIF_R {
        WKUPIF_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - Mode fault interrupt flag"]
    #[inline(always)]
    pub fn mfif(&mut self) -> MFIF_W {
        MFIF_W { w: self }
    }
    #[doc = "Bit 3 - Start of frame"]
    #[inline(always)]
    pub fn sof(&mut self) -> SOF_W {
        SOF_W { w: self }
    }
    #[doc = "Bit 10 - Early suspend"]
    #[inline(always)]
    pub fn esp(&mut self) -> ESP_W {
        ESP_W { w: self }
    }
    #[doc = "Bit 11 - USB suspend"]
    #[inline(always)]
    pub fn sp(&mut self) -> SP_W {
        SP_W { w: self }
    }
    #[doc = "Bit 12 - USB reset"]
    #[inline(always)]
    pub fn rst(&mut self) -> RST_W {
        RST_W { w: self }
    }
    #[doc = "Bit 13 - Enumeration finished"]
    #[inline(always)]
    pub fn enumf(&mut self) -> ENUMF_W {
        ENUMF_W { w: self }
    }
    #[doc = "Bit 14 - Isochronous OUT packet dropped interrupt"]
    #[inline(always)]
    pub fn isoopdif(&mut self) -> ISOOPDIF_W {
        ISOOPDIF_W { w: self }
    }
    #[doc = "Bit 15 - End of periodic frame interrupt flag"]
    #[inline(always)]
    pub fn eopfif(&mut self) -> EOPFIF_W {
        EOPFIF_W { w: self }
    }
    #[doc = "Bit 20 - Isochronous IN transfer Not Complete Interrupt Flag"]
    #[inline(always)]
    pub fn isoincif(&mut self) -> ISOINCIF_W {
        ISOINCIF_W { w: self }
    }
    #[doc = "Bit 21 - periodic transfer not complete interrupt flag(Host mode)/isochronous OUT transfer not complete interrupt flag(Device mode)"]
    #[inline(always)]
    pub fn pxncif_isooncif(&mut self) -> PXNCIF_ISOONCIF_W {
        PXNCIF_ISOONCIF_W { w: self }
    }
    #[doc = "Bit 28 - ID pin status change"]
    #[inline(always)]
    pub fn idpsc(&mut self) -> IDPSC_W {
        IDPSC_W { w: self }
    }
    #[doc = "Bit 29 - Disconnect interrupt flag"]
    #[inline(always)]
    pub fn discif(&mut self) -> DISCIF_W {
        DISCIF_W { w: self }
    }
    #[doc = "Bit 30 - Session interrupt flag"]
    #[inline(always)]
    pub fn sesif(&mut self) -> SESIF_W {
        SESIF_W { w: self }
    }
    #[doc = "Bit 31 - Wakeup interrupt flag"]
    #[inline(always)]
    pub fn wkupif(&mut self) -> WKUPIF_W {
        WKUPIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Global interrupt flag register (USBFS_GINTF)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gintf](index.html) module"]
pub struct GINTF_SPEC;
impl crate::RegisterSpec for GINTF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gintf::R](R) reader structure"]
impl crate::Readable for GINTF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gintf::W](W) writer structure"]
impl crate::Writable for GINTF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GINTF to value 0x0400_0021"]
impl crate::Resettable for GINTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0400_0021
    }
}
