#[doc = "Register `GAHBCS` reader"]
pub struct R(crate::R<GAHBCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GAHBCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GAHBCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GAHBCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GAHBCS` writer"]
pub struct W(crate::W<GAHBCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GAHBCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GAHBCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GAHBCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GINTEN` reader - Global interrupt enable"]
pub struct GINTEN_R(crate::FieldReader<bool, bool>);
impl GINTEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        GINTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GINTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GINTEN` writer - Global interrupt enable"]
pub struct GINTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> GINTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `TXFTH` reader - Tx FIFO threshold"]
pub struct TXFTH_R(crate::FieldReader<bool, bool>);
impl TXFTH_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXFTH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXFTH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXFTH` writer - Tx FIFO threshold"]
pub struct TXFTH_W<'a> {
    w: &'a mut W,
}
impl<'a> TXFTH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `PTXFTH` reader - Periodic Tx FIFO threshold"]
pub struct PTXFTH_R(crate::FieldReader<bool, bool>);
impl PTXFTH_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PTXFTH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PTXFTH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PTXFTH` writer - Periodic Tx FIFO threshold"]
pub struct PTXFTH_W<'a> {
    w: &'a mut W,
}
impl<'a> PTXFTH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Global interrupt enable"]
    #[inline(always)]
    pub fn ginten(&self) -> GINTEN_R {
        GINTEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 7 - Tx FIFO threshold"]
    #[inline(always)]
    pub fn txfth(&self) -> TXFTH_R {
        TXFTH_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Periodic Tx FIFO threshold"]
    #[inline(always)]
    pub fn ptxfth(&self) -> PTXFTH_R {
        PTXFTH_R::new(((self.bits >> 8) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Global interrupt enable"]
    #[inline(always)]
    pub fn ginten(&mut self) -> GINTEN_W {
        GINTEN_W { w: self }
    }
    #[doc = "Bit 7 - Tx FIFO threshold"]
    #[inline(always)]
    pub fn txfth(&mut self) -> TXFTH_W {
        TXFTH_W { w: self }
    }
    #[doc = "Bit 8 - Periodic Tx FIFO threshold"]
    #[inline(always)]
    pub fn ptxfth(&mut self) -> PTXFTH_W {
        PTXFTH_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Global AHB control and status register (USBFS_GAHBCS)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gahbcs](index.html) module"]
pub struct GAHBCS_SPEC;
impl crate::RegisterSpec for GAHBCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gahbcs::R](R) reader structure"]
impl crate::Readable for GAHBCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gahbcs::W](W) writer structure"]
impl crate::Writable for GAHBCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GAHBCS to value 0"]
impl crate::Resettable for GAHBCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
