#[doc = "Register `DIEP3TFLEN` reader"]
pub struct R(crate::R<DIEP3TFLEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIEP3TFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIEP3TFLEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIEP3TFLEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIEP3TFLEN` writer"]
pub struct W(crate::W<DIEP3TFLEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIEP3TFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIEP3TFLEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIEP3TFLEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IEPTXRSAR` reader - IN endpoint FIFO4 transmit RAM start address"]
pub struct IEPTXRSAR_R(crate::FieldReader<u16, u16>);
impl IEPTXRSAR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        IEPTXRSAR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPTXRSAR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPTXRSAR` writer - IN endpoint FIFO4 transmit RAM start address"]
pub struct IEPTXRSAR_W<'a> {
    w: &'a mut W,
}
impl<'a> IEPTXRSAR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
#[doc = "Field `IEPTXFD` reader - IN endpoint TxFIFO depth"]
pub struct IEPTXFD_R(crate::FieldReader<u16, u16>);
impl IEPTXFD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        IEPTXFD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPTXFD_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPTXFD` writer - IN endpoint TxFIFO depth"]
pub struct IEPTXFD_W<'a> {
    w: &'a mut W,
}
impl<'a> IEPTXFD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:15 - IN endpoint FIFO4 transmit RAM start address"]
    #[inline(always)]
    pub fn ieptxrsar(&self) -> IEPTXRSAR_R {
        IEPTXRSAR_R::new((self.bits & 0xffff) as u16)
    }
    #[doc = "Bits 16:31 - IN endpoint TxFIFO depth"]
    #[inline(always)]
    pub fn ieptxfd(&self) -> IEPTXFD_R {
        IEPTXFD_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:15 - IN endpoint FIFO4 transmit RAM start address"]
    #[inline(always)]
    pub fn ieptxrsar(&mut self) -> IEPTXRSAR_W {
        IEPTXRSAR_W { w: self }
    }
    #[doc = "Bits 16:31 - IN endpoint TxFIFO depth"]
    #[inline(always)]
    pub fn ieptxfd(&mut self) -> IEPTXFD_W {
        IEPTXFD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "device IN endpoint transmit FIFO size register (FS_DIEP3TXFLEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [diep3tflen](index.html) module"]
pub struct DIEP3TFLEN_SPEC;
impl crate::RegisterSpec for DIEP3TFLEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [diep3tflen::R](R) reader structure"]
impl crate::Readable for DIEP3TFLEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [diep3tflen::W](W) writer structure"]
impl crate::Writable for DIEP3TFLEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIEP3TFLEN to value 0x0200_0400"]
impl crate::Resettable for DIEP3TFLEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0200_0400
    }
}
