#[doc = "Register `DIEP0TFLEN` reader"]
pub struct R(crate::R<DIEP0TFLEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIEP0TFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIEP0TFLEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIEP0TFLEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIEP0TFLEN` writer"]
pub struct W(crate::W<DIEP0TFLEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIEP0TFLEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIEP0TFLEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIEP0TFLEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `IEP0TXFD` reader - in endpoint 0 Tx FIFO depth"]
pub struct IEP0TXFD_R(crate::FieldReader<u16, u16>);
impl IEP0TXFD_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        IEP0TXFD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEP0TXFD_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEP0TXFD` writer - in endpoint 0 Tx FIFO depth"]
pub struct IEP0TXFD_W<'a> {
    w: &'a mut W,
}
impl<'a> IEP0TXFD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
#[doc = "Field `IEP0TXRSAR` reader - in endpoint 0 Tx RAM start address"]
pub struct IEP0TXRSAR_R(crate::FieldReader<u16, u16>);
impl IEP0TXRSAR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        IEP0TXRSAR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEP0TXRSAR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEP0TXRSAR` writer - in endpoint 0 Tx RAM start address"]
pub struct IEP0TXRSAR_W<'a> {
    w: &'a mut W,
}
impl<'a> IEP0TXRSAR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:15 - in endpoint 0 Tx FIFO depth"]
    #[inline(always)]
    pub fn iep0txfd(&self) -> IEP0TXFD_R {
        IEP0TXFD_R::new((self.bits & 0xffff) as u16)
    }
    #[doc = "Bits 16:31 - in endpoint 0 Tx RAM start address"]
    #[inline(always)]
    pub fn iep0txrsar(&self) -> IEP0TXRSAR_R {
        IEP0TXRSAR_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:15 - in endpoint 0 Tx FIFO depth"]
    #[inline(always)]
    pub fn iep0txfd(&mut self) -> IEP0TXFD_W {
        IEP0TXFD_W { w: self }
    }
    #[doc = "Bits 16:31 - in endpoint 0 Tx RAM start address"]
    #[inline(always)]
    pub fn iep0txrsar(&mut self) -> IEP0TXRSAR_W {
        IEP0TXRSAR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Device IN endpoint 0 transmit FIFO length (Device mode)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [diep0tflen](index.html) module"]
pub struct DIEP0TFLEN_SPEC;
impl crate::RegisterSpec for DIEP0TFLEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [diep0tflen::R](R) reader structure"]
impl crate::Readable for DIEP0TFLEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [diep0tflen::W](W) writer structure"]
impl crate::Writable for DIEP0TFLEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIEP0TFLEN to value 0x0200_0200"]
impl crate::Resettable for DIEP0TFLEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0200_0200
    }
}
