#[doc = "Register `DVBUSPT` reader"]
pub struct R(crate::R<DVBUSPT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DVBUSPT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DVBUSPT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DVBUSPT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DVBUSPT` writer"]
pub struct W(crate::W<DVBUSPT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DVBUSPT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DVBUSPT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DVBUSPT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DVBUSPT` reader - Device VBUS pulsing time"]
pub struct DVBUSPT_R(crate::FieldReader<u16, u16>);
impl DVBUSPT_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        DVBUSPT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DVBUSPT_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DVBUSPT` writer - Device VBUS pulsing time"]
pub struct DVBUSPT_W<'a> {
    w: &'a mut W,
}
impl<'a> DVBUSPT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0fff) | (value as u32 & 0x0fff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:11 - Device VBUS pulsing time"]
    #[inline(always)]
    pub fn dvbuspt(&self) -> DVBUSPT_R {
        DVBUSPT_R::new((self.bits & 0x0fff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:11 - Device VBUS pulsing time"]
    #[inline(always)]
    pub fn dvbuspt(&mut self) -> DVBUSPT_W {
        DVBUSPT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "device VBUS pulsing time register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dvbuspt](index.html) module"]
pub struct DVBUSPT_SPEC;
impl crate::RegisterSpec for DVBUSPT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [dvbuspt::R](R) reader structure"]
impl crate::Readable for DVBUSPT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dvbuspt::W](W) writer structure"]
impl crate::Writable for DVBUSPT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DVBUSPT to value 0x05b8"]
impl crate::Resettable for DVBUSPT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x05b8
    }
}
