#[doc = "Register `DOEPINTEN` reader"]
pub struct R(crate::R<DOEPINTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DOEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DOEPINTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DOEPINTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DOEPINTEN` writer"]
pub struct W(crate::W<DOEPINTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DOEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DOEPINTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DOEPINTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TFEN` reader - Transfer finished interrupt enable"]
pub struct TFEN_R(crate::FieldReader<bool, bool>);
impl TFEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFEN` writer - Transfer finished interrupt enable"]
pub struct TFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `EPDISEN` reader - Endpoint disabled interrupt enable"]
pub struct EPDISEN_R(crate::FieldReader<bool, bool>);
impl EPDISEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPDISEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPDISEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPDISEN` writer - Endpoint disabled interrupt enable"]
pub struct EPDISEN_W<'a> {
    w: &'a mut W,
}
impl<'a> EPDISEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `STPFEN` reader - SETUP phase finished interrupt enable"]
pub struct STPFEN_R(crate::FieldReader<bool, bool>);
impl STPFEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        STPFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STPFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STPFEN` writer - SETUP phase finished interrupt enable"]
pub struct STPFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> STPFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `EPRXFOVREN` reader - Endpoint Rx FIFO overrun interrupt enable"]
pub struct EPRXFOVREN_R(crate::FieldReader<bool, bool>);
impl EPRXFOVREN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPRXFOVREN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPRXFOVREN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPRXFOVREN` writer - Endpoint Rx FIFO overrun interrupt enable"]
pub struct EPRXFOVREN_W<'a> {
    w: &'a mut W,
}
impl<'a> EPRXFOVREN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `BTBSTPEN` reader - Back-to-back SETUP packets interrupt enable"]
pub struct BTBSTPEN_R(crate::FieldReader<bool, bool>);
impl BTBSTPEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        BTBSTPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BTBSTPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BTBSTPEN` writer - Back-to-back SETUP packets interrupt enable"]
pub struct BTBSTPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> BTBSTPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transfer finished interrupt enable"]
    #[inline(always)]
    pub fn tfen(&self) -> TFEN_R {
        TFEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Endpoint disabled interrupt enable"]
    #[inline(always)]
    pub fn epdisen(&self) -> EPDISEN_R {
        EPDISEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - SETUP phase finished interrupt enable"]
    #[inline(always)]
    pub fn stpfen(&self) -> STPFEN_R {
        STPFEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Endpoint Rx FIFO overrun interrupt enable"]
    #[inline(always)]
    pub fn eprxfovren(&self) -> EPRXFOVREN_R {
        EPRXFOVREN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Back-to-back SETUP packets interrupt enable"]
    #[inline(always)]
    pub fn btbstpen(&self) -> BTBSTPEN_R {
        BTBSTPEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transfer finished interrupt enable"]
    #[inline(always)]
    pub fn tfen(&mut self) -> TFEN_W {
        TFEN_W { w: self }
    }
    #[doc = "Bit 1 - Endpoint disabled interrupt enable"]
    #[inline(always)]
    pub fn epdisen(&mut self) -> EPDISEN_W {
        EPDISEN_W { w: self }
    }
    #[doc = "Bit 3 - SETUP phase finished interrupt enable"]
    #[inline(always)]
    pub fn stpfen(&mut self) -> STPFEN_W {
        STPFEN_W { w: self }
    }
    #[doc = "Bit 4 - Endpoint Rx FIFO overrun interrupt enable"]
    #[inline(always)]
    pub fn eprxfovren(&mut self) -> EPRXFOVREN_W {
        EPRXFOVREN_W { w: self }
    }
    #[doc = "Bit 6 - Back-to-back SETUP packets interrupt enable"]
    #[inline(always)]
    pub fn btbstpen(&mut self) -> BTBSTPEN_W {
        BTBSTPEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "device OUT endpoint common interrupt enable register (DOEPINTEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [doepinten](index.html) module"]
pub struct DOEPINTEN_SPEC;
impl crate::RegisterSpec for DOEPINTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [doepinten::R](R) reader structure"]
impl crate::Readable for DOEPINTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [doepinten::W](W) writer structure"]
impl crate::Writable for DOEPINTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DOEPINTEN to value 0"]
impl crate::Resettable for DOEPINTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
