#[doc = "Register `DIEPINTEN` reader"]
pub struct R(crate::R<DIEPINTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DIEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DIEPINTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DIEPINTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DIEPINTEN` writer"]
pub struct W(crate::W<DIEPINTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DIEPINTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DIEPINTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DIEPINTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TFEN` reader - Transfer finished interrupt enable"]
pub struct TFEN_R(crate::FieldReader<bool, bool>);
impl TFEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TFEN` writer - Transfer finished interrupt enable"]
pub struct TFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `EPDISEN` reader - Endpoint disabled interrupt enable"]
pub struct EPDISEN_R(crate::FieldReader<bool, bool>);
impl EPDISEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPDISEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPDISEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPDISEN` writer - Endpoint disabled interrupt enable"]
pub struct EPDISEN_W<'a> {
    w: &'a mut W,
}
impl<'a> EPDISEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CITOEN` reader - Control IN timeout condition interrupt enable (Non-isochronous endpoints)"]
pub struct CITOEN_R(crate::FieldReader<bool, bool>);
impl CITOEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CITOEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CITOEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CITOEN` writer - Control IN timeout condition interrupt enable (Non-isochronous endpoints)"]
pub struct CITOEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CITOEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `EPTXFUDEN` reader - Endpoint Tx FIFO underrun interrupt enable bit"]
pub struct EPTXFUDEN_R(crate::FieldReader<bool, bool>);
impl EPTXFUDEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        EPTXFUDEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EPTXFUDEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EPTXFUDEN` writer - Endpoint Tx FIFO underrun interrupt enable bit"]
pub struct EPTXFUDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> EPTXFUDEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `IEPNEEN` reader - IN endpoint NAK effective interrupt enable"]
pub struct IEPNEEN_R(crate::FieldReader<bool, bool>);
impl IEPNEEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        IEPNEEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IEPNEEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IEPNEEN` writer - IN endpoint NAK effective interrupt enable"]
pub struct IEPNEEN_W<'a> {
    w: &'a mut W,
}
impl<'a> IEPNEEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TXFEEN` reader - Trabsmit FIFO empty interrupt enable"]
pub struct TXFEEN_R(crate::FieldReader<bool, bool>);
impl TXFEEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXFEEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXFEEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXFEEN` writer - Trabsmit FIFO empty interrupt enable"]
pub struct TXFEEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TXFEEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transfer finished interrupt enable"]
    #[inline(always)]
    pub fn tfen(&self) -> TFEN_R {
        TFEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Endpoint disabled interrupt enable"]
    #[inline(always)]
    pub fn epdisen(&self) -> EPDISEN_R {
        EPDISEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Control IN timeout condition interrupt enable (Non-isochronous endpoints)"]
    #[inline(always)]
    pub fn citoen(&self) -> CITOEN_R {
        CITOEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Endpoint Tx FIFO underrun interrupt enable bit"]
    #[inline(always)]
    pub fn eptxfuden(&self) -> EPTXFUDEN_R {
        EPTXFUDEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 6 - IN endpoint NAK effective interrupt enable"]
    #[inline(always)]
    pub fn iepneen(&self) -> IEPNEEN_R {
        IEPNEEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Trabsmit FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn txfeen(&self) -> TXFEEN_R {
        TXFEEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transfer finished interrupt enable"]
    #[inline(always)]
    pub fn tfen(&mut self) -> TFEN_W {
        TFEN_W { w: self }
    }
    #[doc = "Bit 1 - Endpoint disabled interrupt enable"]
    #[inline(always)]
    pub fn epdisen(&mut self) -> EPDISEN_W {
        EPDISEN_W { w: self }
    }
    #[doc = "Bit 3 - Control IN timeout condition interrupt enable (Non-isochronous endpoints)"]
    #[inline(always)]
    pub fn citoen(&mut self) -> CITOEN_W {
        CITOEN_W { w: self }
    }
    #[doc = "Bit 4 - Endpoint Tx FIFO underrun interrupt enable bit"]
    #[inline(always)]
    pub fn eptxfuden(&mut self) -> EPTXFUDEN_W {
        EPTXFUDEN_W { w: self }
    }
    #[doc = "Bit 6 - IN endpoint NAK effective interrupt enable"]
    #[inline(always)]
    pub fn iepneen(&mut self) -> IEPNEEN_W {
        IEPNEEN_W { w: self }
    }
    #[doc = "Bit 7 - Trabsmit FIFO empty interrupt enable"]
    #[inline(always)]
    pub fn txfeen(&mut self) -> TXFEEN_W {
        TXFEEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "device IN endpoint common interrupt mask register (DIEPINTEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [diepinten](index.html) module"]
pub struct DIEPINTEN_SPEC;
impl crate::RegisterSpec for DIEPINTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [diepinten::R](R) reader structure"]
impl crate::Readable for DIEPINTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [diepinten::W](W) writer structure"]
impl crate::Writable for DIEPINTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DIEPINTEN to value 0"]
impl crate::Resettable for DIEPINTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
